% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_sample_functions.R
\name{sits_sample}
\alias{sits_sample}
\title{Sample a percentage of a time series}
\usage{
sits_sample(data, n = NULL, frac = NULL, oversample = TRUE)
}
\arguments{
\item{data}{Input sits tibble.}

\item{n}{Number of samples to pick from each group of data.}

\item{frac}{Percentage of samples to pick from each group of data.}

\item{oversample}{Oversample classes with small number of samples?}
}
\value{
A sits tibble with a fixed quantity of samples.
}
\description{
Takes a sits tibble with different labels and
             returns a new tibble. For a given field as a group criterion,
             this new tibble contains a given number or percentage
             of the total number of samples per group.
             Parameter n: number of random samples.
             Parameter frac: a fraction of random samples.
             If n is greater than the number of samples for a given label,
             that label will be sampled with replacement. Also,
             if frac > 1 , all sampling will be done with replacement.
}
\examples{
# Retrieve a set of time series with 2 classes
data(cerrado_2classes)
# Print the labels of the resulting tibble
sits_labels(cerrado_2classes)
# Samples the data set
data <- sits_sample(cerrado_2classes, n = 10)
# Print the labels of the resulting tibble
sits_labels(data)
}
\author{
Rolf Simoes, \email{rolf.simoes@inpe.br}
}
