% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_plot.R
\name{plot.uncertainty_cube}
\alias{plot.uncertainty_cube}
\title{Plot uncertainty cubes}
\usage{
\method{plot}{uncertainty_cube}(
  x,
  ...,
  tile = x$tile[[1]],
  palette = "RdYlGn",
  rev = TRUE,
  tmap_options = NULL
)
}
\arguments{
\item{x}{Object of class "probs_image".}

\item{...}{Further specifications for \link{plot}.}

\item{tile}{Tiles to be plotted.}

\item{palette}{An RColorBrewer palette}

\item{rev}{Reverse the color order in the palette?}

\item{tmap_options}{List with optional tmap parameters
tmap_max_cells (default: 1e+06)
tmap_graticules_labels_size (default: 0.7)
tmap_legend_title_size (default: 1.5)
tmap_legend_text_size (default: 1.2)
tmap_legend_bg_color (default: "white")
tmap_legend_bg_alpha (default: 0.5)}
}
\value{
A plot object produced by the stars package
                      with a map showing the uncertainty associated
                      to each classified pixel.
}
\description{
plots a probability cube using stars
}
\examples{
if (sits_run_examples()) {
    # create a random forest model
    rfor_model <- sits_train(samples_modis_ndvi, sits_rfor())
    # create a data cube from local files
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6",
        data_dir = data_dir
    )
    # classify a data cube
    probs_cube <- sits_classify(
        data = cube, ml_model = rfor_model, output_dir = tempdir()
    )
    # calculate uncertainty
    uncert_cube <- sits_uncertainty(probs_cube, output_dir = tempdir())
    # plot the resulting uncertainty cube
    plot(uncert_cube)
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
