% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_variance.R
\name{sits_variance}
\alias{sits_variance}
\title{Calculate the variance of a probability cube}
\usage{
sits_variance(
  cube,
  window_size = 9,
  neigh_fraction = 0.5,
  multicores = 2,
  memsize = 4,
  output_dir,
  version = "v1"
)
}
\arguments{
\item{cube}{Probability data cube.}

\item{window_size}{Size of the neighborhood.}

\item{neigh_fraction}{Fraction of neighbors with highest probability
to be used in Bayesian inference.}

\item{multicores}{Number of cores to run the smoothing function}

\item{memsize}{Maximum overall memory (in GB) to run the
smoothing.}

\item{output_dir}{Output directory for image files}

\item{version}{Version of resulting image
(in the case of multiple tests)}
}
\value{
A variance data cube.
}
\description{
Takes a probability cube and estimate the local variance
             of the logit of the probability,
             to support the choice of parameters for Bayesian smoothing.
}
\note{
Please refer to the sits documentation available in
<https://e-sensing.github.io/sitsbook/> for detailed examples.
}
\examples{
if (sits_run_examples()) {
    # create a ResNet model
    rfor_model <- sits_train(samples_modis_ndvi, sits_rfor())
    # create a data cube from local files
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6",
        data_dir = data_dir,
        delim = "_",
        parse_info = c("X1", "tile", "band", "date")
    )
    # classify a data cube
    probs_cube <- sits_classify(
        data = cube, ml_model = rfor_model, output_dir = tempdir()
    )
    # plot the probability cube
    plot(probs_cube)
    # smooth the probability cube using Bayesian statistics
    var_cube <- sits_variance(probs_cube, output_dir = tempdir())
    # plot the variance cube
    plot(var_cube)
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}

Rolf Simoes, \email{rolf.simoes@inpe.br}
}
