% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_colors.R
\name{sits_colors}
\alias{sits_colors}
\title{Function to handle colors in SITS}
\usage{
sits_colors(name, n_colors = 32)
}
\arguments{
\item{name}{Name of sits color palette}

\item{n_colors}{Number of colors to be displayed}
}
\value{
A vector with valid R colors
}
\description{
Returns a color palette for plotting

Implements support RColorBrewer and named sits palettes. Valid names are:
"veg_index", "probs", "uncert", "soil", "forest", "water", "green",
"BuGn", "BuPu", "GnBu", "PuBu", "PuBuGn", "PuRd", "YlGn", "YlGnBu", "YlOrRd",
"YlOrBr", "OrRd", "Blues", "Greens", "Oranges", "Reds", "Greys", "Purples".
}
\examples{
if (sits_run_examples()) {
    # show the names of the colors supported by SITS
    sits_color_names()
    # show a color palette
    sits_colors_show("Blues", n_colors = 16)
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
