% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apv_se.R
\name{apv_se}
\alias{apv_se}
\title{Bootstrap standard errors for SITAR peak velocity and age at peak velocity}
\usage{
apv_se(object, fun = getPeak, nboot = 10, seed = NULL, plot = FALSE, ...)
}
\arguments{
\item{object}{SITAR model.}

\item{fun}{function to extract apv and pv from velocity curve (default getPeak),
alternative getTakeoff or getTrough.}

\item{nboot}{number of bootstrap samples (default 10).}

\item{seed}{integer to initialize the random number generator (default NULL).}

\item{plot}{logical to control plotting (default FALSE).}

\item{\dots}{optional arguments defining the velocity curve to be bootstrapped
(\code{plot.sitar} arguments \code{xfun}, \code{yfun}, \code{subset}, \code{ns}
or \code{abc}), and graphical \code{par} parameters.}
}
\value{
a 2x2 array giving the mean and standard error of apv and pv, with
attribute "bs" a tibble containing the bootstrap estimates of apv and pv,
with NAs removed.
}
\description{
\code{apv_se} bootstraps a SITAR model to generate standard errors for
age at peak velocity (apv) and peak velocity (pv).
}
\details{
If \code{plot} is TRUE, the original velocity curve is plotted along with
each bootstrap sample's pv versus apv.
}
\examples{
data(heights)
## fit sitar model for height
model <- sitar(x = age, y = height, id = id, data = heights, df = 4)

## bootstrap standard errors for age at peak velocity and peak velocity
output <- apv_se(model, nboot=3, seed=111, plot=TRUE)
}
\author{
Tim Cole \email{tim.cole@ucl.ac.uk}
}
