% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iotf.R
\docType{data}
\name{iotf}
\alias{iotf}
\title{IOTF international body mass index reference}
\format{A tibble with 66 observations on the following 5 variables:
\describe{
\item{years}{numeric vector - postnatal age in years}
\item{L.bmi}{numeric vector}
\item{M.bmi}{numeric vector}
\item{S.bmi}{numeric vector}
\item{sex}{two-level factor with level 1 male and level 2 female} }}
\source{
The values are tabulated in the Excel spreadsheet IOTF_LMS.xls
provided with the Excel add-in LMSgrowth from
\url{http://www.healthforallchildren.com/?product_cat=software}.
}
\usage{
iotf
}
\description{
The IOTF (International Obesity TaskForce) BMI growth reference
(Cole and Lobstein 2012), fitted by the LMS method and summarised by values
of L, M and S by sex and postnatal age from 2 to 18 years.
}
\details{
The IOTF cutoffs for overweight and obesity (and also thinness) (see
Cole et al 2000, 2007) can be obtained from this BMI reference.
See the example for how to convert between cutoffs and z-scores.

The L, M and S values for each measurement correspond respectively to the
Box-Cox power, median and coefficient of variation of the distribution by
age and sex (Cole & Green 1992). The measurement short name and units
for \code{\link{LMS2z}} are bmi (kg/m2).
}
\examples{
data(iotf)
## calculate z-scores by sex corresponding to IOTF cutoffs for thinness,
## overweight and obesity
co <- data.frame(cutoff = c(16, 17, 18.5, 25, 30),
  grade = c('thinness 3', 'thinness 2', 'thinness 1',
    'overweight', 'obesity'))
sexes <- c('boys', 'girls')
with(co,
  cbind(co, lapply(setNames(sexes, sexes), function(x)
    LMS2z(x = 18, y = cutoff, sex = x,
          measure = 'bmi', ref = 'iotf'))))
}
\references{
Cole TJ, Green PJ. Smoothing reference centile curves: the LMS
method and penalized likelihood. Stat Med 1992;11:1305-19.

Cole TJ, Bellizzi MC, Flegal KM, Dietz WH. Establishing a standard
definition for child overweight and obesity worldwide: international survey.
BMJ 2000;320:1240-3.

Cole TJ, Flegal KM, Nicholls D, Jackson AA. Body mass index cut offs to
define thinness in children and adolescents: international survey.
BMJ 2007;335:194-7.

Cole TJ, Lobstein T. Extended international (IOTF) body mass index cut-offs
for thinness, overweight and obesity. Ped Obes 2012;7:284-94.
}
\keyword{datasets}
