% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sirus.R
\name{sirus.print}
\alias{sirus.print}
\title{Print SIRUS.}
\usage{
sirus.print(sirus.m, digits = 3)
}
\arguments{
\item{sirus.m}{A SIRUS model generated by \code{\link{sirus.fit}}.}

\item{digits}{Number of significant digits for numerical values. Default value is 3.}
}
\value{
Formatted list of rules.
}
\description{
Print the list of rules output by SIRUS.
}
\examples{
## load SIRUS
require(sirus)

## prepare data
data <- iris
y <- rep(0, nrow(data))
y[data$Species == 'setosa'] = 1
data$Species <- NULL

## fit SIRUS
sirus.m <- sirus.fit(data, y)

## print sirus model
sirus.print(sirus.m)

}
