% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sirus.R
\name{sirus.plot.cv}
\alias{sirus.plot.cv}
\title{Plot SIRUS cross-validation.}
\usage{
sirus.plot.cv(sirus.cv.grid, num.rule.max = 25)
}
\arguments{
\item{sirus.cv.grid}{Cross-validation results returned by sirus.cv.}

\item{num.rule.max}{Upper limit on the number of rules for the x-axis. Default is 25.}
}
\value{
Plots of cross-validation results.
  \item{\code{error}}{plot of 1-AUC vs number of rules (ggplot object).}
  \item{\code{stab}}{plot of stability vs number of rules (ggplot object).}
}
\description{
Plot SIRUS cross-validation path: 1-AUC and stability versus the number of rules when p0 varies.
}
\examples{
## load sirus
require(sirus)

## prepare data
data <- iris
y <- rep(0, nrow(data))
y[data$Species == 'setosa'] = 1
data$Species <- NULL

## run cv
cv.grid <- sirus.cv(data, y, nfold = 3, ncv = 2, num.trees = 100)

## plot cv result
plot.error <- sirus.plot.cv(cv.grid)$error
plot(plot.error)

}
