% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/haystack_highD.R
\name{haystack_highD}
\alias{haystack_highD}
\title{The main Haystack function, for higher-dimensional spaces.}
\usage{
haystack_highD(
  x,
  detection,
  grid.points = 100,
  use.advanced.sampling = NULL,
  dir.randomization = NULL,
  scale = TRUE,
  grid.method = "centroid"
)
}
\arguments{
\item{x}{Coordinates of cells in a 2D or higher-dimensional space. Rows represent cells, columns the dimensions of the space.}

\item{detection}{A logical matrix showing which genes (rows) are detected in which cells (columns)}

\item{grid.points}{An integer specifying the number of centers (grid points) to be used for estimating the density distributions of cells. Default is set to 100.}

\item{use.advanced.sampling}{If NULL naive sampling is used. If a vector is given (of length = no. of cells) sampling is done according to the values in the vector.}

\item{dir.randomization}{If NULL, no output is made about the random sampling step. If not NULL, files related to the randomizations are printed to this directory.}

\item{scale}{Logical (default=TRUE) indicating whether input coordinates in x should be scaled to mean 0 and standard deviation 1.}

\item{grid.method}{The method to decide grid points for estimating the density in the high-dimensional space. Should be "centroid" (default) or "seeding".}
}
\value{
An object of class "haystack", including the results of the analysis, and the coordinates of the grid points used to estimate densities.
}
\description{
The main Haystack function, for higher-dimensional spaces.
}
\examples{
# I need to add some examples.
# A toy example will be added too.
}
