% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAvgTemp.R
\name{plotAvgTemp}
\alias{plotAvgTemp}
\title{Plot average temperature}
\usage{
plotAvgTemp(
  mydata,
  temp = "temp",
  avg.time = "1 month",
  ylabel = "Temperatura [C]",
  title = ""
)
}
\arguments{
\item{mydata}{A data frame containing fields date and temp}

\item{temp}{Name of the column representing temperature}

\item{avg.time}{This defines the time period to average to
(see openair::timeAverage). Default is "1 month".}

\item{ylabel}{The label to be plot along y axis}

\item{title}{Option plot title}
}
\value{
A plot with average, min and max temperature in a given
range of time.
}
\description{
\code{plotAvgTemp} builds a bar plot of time average temperature and two
line plots with maximum and minimum temperature.
}
\note{
\code{plotAvgTemp} uses \code{openair::timeAvearge} to compute
average.
}
\examples{
# Plot histogram with monthly averages together with maxima and minima 
# curves
data(stMeteo)
plotAvgTemp(stMeteo)
plotAvgTemp(stMeteo, temp = "temperature", 
            avg.time = "1 month", ylabel = "Temperatura [C]")
}
