% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{find_best_fit}
\alias{find_best_fit}
\title{Find The Best Fitting Distribution}
\usage{
find_best_fit(
  x,
  positive = FALSE,
  plot = TRUE,
  legend.pos = "topright",
  dlc = NULL,
  dlw = 1,
  ...
)
}
\arguments{
\item{x}{a numeric vector; data.}

\item{positive}{a logical constant; distribution type.}

\item{plot}{a logical constant. If \code{TRUE} (default), a histogram and density lines are drawn.}

\item{legend.pos}{a character string. Indicates the legend position and must be one of "bottomright", "bottom", "bottomleft", "left", "topleft", "top", "topright" (default), "right" and "center".}

\item{dlc}{a vector; probability density line colors for supported (up to 7) distributions. If unspecified, the rainbow color palette will be used.}

\item{dlw}{a numerical constant; probability density line width.}

\item{...}{Further arguments and parameters for the function \code{\link[graphics]{hist}}, particularly, main title and axis labels. However, the parameter \code{freq} is not able to override.}
}
\value{
A list containing the following items:
\describe{
\item{distribution}{the name of the best fitting distribution.}
\item{ks.statistic}{the Kolmogorov-Smirnov test statistic for the distribution.}
\item{p.value}{the p-value of the test.}
\item{summary}{results similar to above for other distributions.}
\item{x}{given data.}
\item{n}{the sample size.}
}
}
\description{
It finds the best fitting distribution from supported univariate continuous distributions for given data.
}
\details{
This function is supported following univariate distributions:
\itemize{
 \item for positive random variables: Log normal, Exponential, Gamma and Weibull.
 \item for all random variables: Normal, Cauchy, Log normal, Exponential, Gamma, Weibull and Uniform.
}

Legends of the plot are ordered by p-values of the test.
}
\examples{
petal.length <- datasets::iris$Petal.Length[datasets::iris$Species == "setosa"]
simukde::find_best_fit(x = petal.length, positive = TRUE)
}
\references{
\enumerate{
 \item William J. Conover (1971). Practical Nonparametric Statistics. New York: John Wiley & Sons. Pages 295–301.
 \item Venables, W. N. and Ripley, B. D. (2002) Modern Applied Statistics with S. Fourth edition. Springer.
}
}
\seealso{
\code{\link[stats]{ks.test}}, \code{\link[MASS]{fitdistr}}, \code{\link[graphics]{hist}}
}
