% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{iccRE}
\alias{iccRE}
\title{Generate variance for random effects that produce desired intra-class
coefficients (ICCs) for clustered data.}
\usage{
iccRE(ICC, dist, varTotal = NULL, varWithin = NULL, lambda = NULL, disp = NULL)
}
\arguments{
\item{ICC}{Vector of values between 0 and 1 that represent the
target ICC levels}

\item{dist}{The distribution that describes the outcome data at the
individual level. Possible distributions include "normal", "binary",
"poisson", or "gamma"}

\item{varTotal}{Numeric value that represents the total variation for a
normally distributed model. If "normal" distribution is specified, either
varTotal or varWithin must be specified, but not both.}

\item{varWithin}{Numeric value that represents the variation within a
cluster for a normally distributed model. If "normal" distribution is
specified, either varTotal or varWithin must be specified, but not both.}

\item{lambda}{Numeric value that represents the grand mean. Must be specified
when distribution is "poisson" or "negative binomial".}

\item{disp}{Numeric value that represents the dispersion parameter that is used
to define a gamma or negative binomial distribution with a log link. Must be
specified when distribution is "gamma".}
}
\value{
A vector of values that represents the variances of random effects
at the cluster level that correspond to the ICC vector.
}
\description{
Generate variance for random effects that produce desired intra-class
coefficients (ICCs) for clustered data.
}
\examples{
targetICC <- seq(0.05, 0.20, by = .01)

iccRE(targetICC, "poisson", lambda = 30)

iccRE(targetICC, "binary")

iccRE(targetICC, "normal", varTotal = 100)
iccRE(targetICC, "normal", varWithin = 100)

iccRE(targetICC, "gamma", disp = .5)

iccRE(targetICC, "negBinomial", lambda = 40, disp = .5)
}
\concept{utility}
