% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genSurv.R
\name{genSurv}
\alias{genSurv}
\title{Generate survival data}
\usage{
genSurv(dtName, survDefs)
}
\arguments{
\item{dtName}{Name of complete data set}

\item{survDefs}{Definitions of survival}
}
\value{
Original matrix with survival time
}
\description{
Survival data is added to an existing data set.
}
\examples{
# Baseline data definitions

def <- defData(varname = "x1", formula = .5, dist = "binary")
def <- defData(def,varname = "x2", formula = .5, dist = "binary")
def <- defData(def,varname = "grp", formula = .5, dist = "binary")

# Survival data definitions

sdef <- defSurv(varname = "survTime", formula = "1.5*x1",
                scale = "grp*50 + (1-grp)*25", shape = "grp*1 + (1-grp)*1.5")

sdef <- defSurv(sdef, varname = "censorTime", scale = 80, shape = 1)

sdef

# Baseline data definitions

dtSurv <- genData(300, def)

# Add survival times

dtSurv <- genSurv(dtSurv, sdef)

head(dtSurv)

}

