% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defData.R
\name{defData}
\alias{defData}
\title{Add single row to definitions table}
\usage{
defData(
  dtDefs = NULL,
  varname,
  formula,
  variance = 0,
  dist = "normal",
  link = "identity",
  id = "id"
)
}
\arguments{
\item{dtDefs}{Definition data.table to be modified}

\item{varname}{Name (string) of new variable}

\item{formula}{An R expression for mean (string)}

\item{variance}{Number}

\item{dist}{Distribution. For possibilities, see details}

\item{link}{The link function for the mean, see details}

\item{id}{A string indicating the field name for the unique record identifier}
}
\value{
A data.table named dtName that is an updated data definitions table
}
\description{
Add single row to definitions table
}
\details{
The possible data distributions include "normal", "poisson", 
"noZeroPoisson", "negBinomial" "binary", "binomial", "beta", "uniform", 
"uniformInt", "categorical", "gamma", "exponential", 
"mixture", and "nonrandom."
}
\examples{
def <- defData(varname = "xNr", dist = "nonrandom", formula=7, id = "idnum")
def <- defData(def, varname="xUni", dist="uniform", formula="10;20")
def <- defData(def, varname="xNorm", formula="xNr + xUni * 2", dist="normal", variance=8)
def <- defData(def, varname="xPois", dist="poisson", formula="xNr - 0.2 * xUni", link="log")
def <- defData(def, varname="xCat", formula = "0.3;0.2;0.5", dist="categorical")
def <- defData(def, varname="xGamma", dist="gamma", formula = "5+xCat", variance = 1, link = "log")
def <- defData(def, varname = "xBin", dist = "binary" , formula="-3 + xCat", link="logit")
def
}
