% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genFactor.R
\name{genFactor}
\alias{genFactor}
\title{Create factor variable from an existing (non-double) variable}
\usage{
genFactor(dtName, varname, labels = NULL, prefix = "f",
  replace = FALSE)
}
\arguments{
\item{dtName}{Data table with column}

\item{varname}{Name of field that is to be converted}

\item{labels}{Factor level labels. If not provided, the generated factor
levels will be used as the labels.}

\item{prefix}{By default, the new field name will be a concatenation of "f"
and the old field name. A prefix string can be provided.}

\item{replace}{If replace is set to TRUE (defaults to FALSE) the field
referenced varname will be removed.}
}
\description{
Create factor variable from an existing (non-double) variable
}
\examples{

# First example:

def <- defData(varname = "cat", formula = ".2;.3;.5", dist="categorical")
def <- defData(def, varname = "x", formula = 5, variance = 2)

dx <- genData(200,def)
dx

dx <- genFactor(dx, "cat", labels = c("one", "two", "three"))
dx

# Second example:

dx <- genData(10)
dx <- trtAssign(dtName = dx, 2, grpName = "studyArm")
dx <- genFactor(dx, varname = "studyArm", labels = c("control", "treatment"), prefix = "t_")
dx
}
