% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genSpline.R
\name{genSpline}
\alias{genSpline}
\title{Generate spline curves}
\usage{
genSpline(dt, newvar, predictor, theta, knots = c(0.25, 0.5, 0.75),
  degree = 3, newrange = NULL, noise.var = 0)
}
\arguments{
\item{dt}{data.table that will be modified}

\item{newvar}{Name of new variable to be created}

\item{predictor}{Name of field in old data.table that is predicting new value}

\item{theta}{A vector or matrix of values between 0 and 1. Each column of the matrix
represents the weights/coefficients that will be applied to the basis functions
determined by the knots and degree. Each column of theta represents a separate
spline curve.}

\item{knots}{A vector of values between 0 and 1, specifying quantile
cut-points for splines. Defaults to c(0.25, 0.50, 0.75).}

\item{degree}{Integer specifying polynomial degree of curvature.}

\item{newrange}{Range of the spline function , specified as a string
with two values separated by a semi-colon. The first value represents the
minimum, and the second value represents the maximum. Defaults to NULL, which
sets the range to be between 0 and 1.}

\item{noise.var}{Add to normally distributed noise to observation - where mean
is value of spline curve.}
}
\value{
A modified data.table with an added column named newvar.
}
\description{
Generate spline curves
}
\examples{
ddef <- defData(varname = "age", formula = "0;1", dist = "uniform")

theta1 = c(0.1, 0.8, 0.6, 0.4, 0.6, 0.9, 0.9)
knots <- c(0.25, 0.5, 0.75)

viewSplines(knots = knots, theta = theta1, degree = 3)

set.seed(234)
dt <- genData(1000, ddef)

dt <- genSpline(dt = dt, newvar = "weight",
                predictor = "age", theta = theta1,
                knots = knots, degree = 3,
                noise.var = .025)

dt

}
