% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simrec_plot.R
\name{simreccompPlot}
\alias{simreccompPlot}
\title{simreccompPlot}
\usage{
simreccompPlot(
  data,
  id = "id",
  start = "start",
  stop = "stop",
  status = "status"
)
}
\arguments{
\item{data}{A data set of recurrent event data to be plotted.
The input-data must include columns corresponding to:
\code{id} (patient-ID), \code{start} (= beginning of an interval where the patient is at risk for an event),
\code{stop} (= end of the interval due to an event or censoring),
\code{status} (= an indicator of the patient status at \code{stop} with = 0 censoring, 1 = event, 2 = competing event)}

\item{id}{the name of the \code{id} column, default is \code{"id"}}

\item{start}{the name of the \code{start} column, default is \code{"start"}}

\item{stop}{the name of the \code{stop} column, default is \code{"stop"}}

\item{status}{the name of the \code{status} column, default is \code{"status"}}
}
\value{
The output  is a plot of the data with a bullet indicating a recurrent event, an x indicating the competing event and a circle indicating censoring.
}
\description{
This function allows plotting of recurrent event data with a competing event.
}
\examples{
### Example:
### First simulate a sample of 10 individuals (for more details see the help of \code{simreccomp})
N <- 10
dist.x <- c("binomial", "normal")
par.x <- list(0.5, c(0, 1))
beta.xr <- c(0.3, 0.2)
beta.xc <- c(0.5, 0.25)
dist.zr <- "gamma"
par.zr <- 0.25
dist.zc <- "gamma"
par.zc <- 0.3
dist.rec <- "weibull"
par.rec <- c(1, 2)
dist.comp <- "weibull"
par.comp <- c(1, 2)
fu.min <- 2
fu.max <- 2
cens.prob <- 0.2
dfree <- 30 / 365
pfree <- 0.5
simdata <- simreccomp(
  N = N, fu.min = fu.min, fu.max = fu.max, cens.prob = cens.prob,
  dist.x = dist.x, par.x = par.x, beta.xr = beta.xr, beta.xc = beta.xc,
  dist.zr = dist.zr, par.zr = par.zr, dist.zc = dist.zc, par.zc = par.zc,
  dist.rec = dist.rec, par.rec = par.rec, dist.comp = dist.comp, par.comp = par.comp,
  pfree = pfree, dfree = dfree
)
simreccompPlot(simdata)
}
\seealso{
simrec, simreccomp, simrecPlot
}
\author{
Katharina Ingel, Stella Preussler, Antje Jahn-Eimermacher.
Institute of Medical Biostatistics, Epidemiology and Informatics (IMBEI),
University Medical Center of the Johannes Gutenberg-University Mainz, Germany
}
