% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify.R
\name{modify}
\alias{modify}
\alias{fixef<-}
\alias{coef<-}
\alias{VarCorr<-}
\alias{sigma<-}
\alias{scale<-}
\title{Modifying model parameters.}
\usage{
fixef(object) <- value

coef(object) <- value

VarCorr(object) <- value

sigma(object) <- value

scale(object) <- value
}
\arguments{
\item{object}{a fitted model object.}

\item{value}{new parameter values.}
}
\description{
These functions can be used to change the size of a model's fixed effects,
its random effect variance/covariance matrices, or its residual variance.
This gives you more control over simulations from the model.
}
\details{
New values for \code{VarCorr} are interpreted as variances and covariances, not standard deviations and
correlations. New values for \code{sigma} and \code{scale} are interpreted on the standard deviation scale.
This means that both \code{VarCorr(object)<-VarCorr(object)} and \code{sigma(object)<-sigma(object)}
leave \code{object} unchanged, as you would expect.

\code{sigma<-} will only change the residual standard deviation,
whereas \code{scale<-} will affect both \code{sigma} and \code{VarCorr}.

These function can be used to change the value of individual parameters, such as
a single fixed effect coefficient, using standard R subsetting commands.
}
\examples{
fm <- lmer(y ~ x + (1|g), data=simdata)
fixef(fm)
fixef(fm)["x"] <- -0.1
fixef(fm)

}
\seealso{
\code{\link{getData}} if you want to modify the model's data.
}
