% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelimpute.R
\name{impute}
\alias{impute}
\alias{impute_}
\title{Impute using a previously fitted model.}
\usage{
impute(dat, formula, predictor = foretell, ...)

impute_(dat, variables, model, predictor = foretell, ...)
}
\arguments{
\item{dat}{\code{[data.frame]} The data to be imputed.}

\item{formula}{\code{[formula]} object of the form 
\code{<imputed variables> ~ <model object>}}

\item{predictor}{\code{[function]} with signature \code{object, newdata, ...}
that returns predicted values given a model \code{object} and a new dataset
\code{newdata}. By default \code{\link{foretell}} is used.}

\item{...}{Extra arguments passed to \code{predictor}}

\item{variables}{\code{[character]} Names of columns in \code{dat} to impute.}

\item{model}{A model object.}
}
\description{
Impute one or more variables using a single R object representing a 
previously fitted model.
}
\section{Model specification}{


Formulas are of the form

\code{IMPUTED_VARIABLES ~ MODEL_OBJECT }

The left-hand-side of the formula object lists the variable or variables to 
be imputed. The right-hand-side must be a model object for which an \code{S3}
\code{predict} method is implemented. Alternatively, one can specify a custom
predicting function. This function must accept at least a model and a
dataset, and return one predicted value for each row in the dataset.

\code{\link{foretell}} implements usefull \code{predict} methods for cases
where by default the predicted output is not of the same type as the predicted
variable (e.g. when using certain link functions in \code{glm})
}

\section{Details}{


\code{impute_} is an explicit version of \code{impute} that works better in
programming contexts, especially in cases involving nonstandard evaluation.
}

\examples{

irisNA <- iris
iris[1:3,1] <- NA
my_model <- lm(Sepal.Length ~ Sepal.Width + Species, data=iris)
impute(irisNA, Sepal.Length ~ my_model)

}
\seealso{
Other imputation: \code{\link{impute_cart}},
  \code{\link{impute_hotdeck}}, \code{\link{impute_lm}}
}
