% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplex_tree.R
\name{generate_ids}
\alias{generate_ids}
\alias{id_policy}
\title{Generates vertex ids.}
\usage{
generate_ids(st, n)
}
\arguments{
\item{st}{a simplex tree.}

\item{n}{the number of ids to generate.}
}
\description{
Generates vertex ids representing 0-simplices not in the tree.
}
\details{
This function generates new vertex ids for use in situations which involve generating new 
new 0-simplices, e.g. insertions, contractions, collapses, etc. There are two 'policies' which designate 
the generating mechanism of these ids: 'compressed' and 'unique'. 'compressed' generates vertex ids 
sequentially, starting at 0. 'unique' tracks an incremental internal counter, which is updated on every 
call to \code{generate_ids}. The new ids under the 'unique' policy generates the first sequential \code{n} 
ids that are strictly greater  \code{max}(\emph{counter}, \emph{max vertex id}). \cr
\cr
}
\examples{
st <- simplex_tree()
print(st$id_policy)
## "compressed"
st \%>\% generate_ids(3) 
## 0 1 2
st \%>\% generate_ids(3) 
## 0 1 2
st \%>\% insert(list(1,2,3))
print(st$vertices) 
## 1 2 3
st \%>\% insert(as.list(st \%>\% generate_ids(2)))
st \%>\% print_simplices() 
# 0, 1, 2, 3, 4
st \%>\% remove(4)
st \%>\% generate_ids(1) 
# 4
}
