% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_stars.R
\name{gg_stars_col}
\alias{gg_stars_col}
\title{Stars ggplot map that is coloured.}
\usage{
gg_stars_col(
  data,
  col_var,
  borders = NULL,
  borders_on_top = TRUE,
  downsample = 0,
  pal = NULL,
  pal_na = "#7F7F7F",
  pal_rev = FALSE,
  pal_borders = "#7F7F7F",
  alpha_fill = 1,
  alpha_borders = 0.5,
  size_borders = 0.2,
  title = NULL,
  title_wrap = 80,
  subtitle = NULL,
  subtitle_wrap = 80,
  col_breaks_n = 4,
  col_cuts = NULL,
  col_intervals_left = TRUE,
  col_labels = NULL,
  col_legend_none = FALSE,
  col_na_rm = FALSE,
  col_method = NULL,
  col_title = NULL,
  col_title_wrap = 25,
  caption = NULL,
  caption_wrap = 80,
  theme = gg_theme(void = TRUE),
  mobile = FALSE
)
}
\arguments{
\item{data}{A stars object with defined coordinate reference system in a structure to be plotted untransformed. Note, it cannot be a stars_proxy object. Required input.}

\item{col_var}{Unquoted variable for points to be coloured by. Required input.}

\item{borders}{A sf object as administrative boundaries (or coastlines). Defaults to no boundaries added. The rnaturalearth package is a useful source of country and state boundaries.}

\item{borders_on_top}{TRUE or FALSE  as to whether the borders are on top of the stars array. Defaults to TRUE.}

\item{downsample}{downsampling rate: e.g. 3 keeps rows and cols 1, 4, 7, 10 etc. A value of 0 does not downsample. It can be specified for each dimension. E.g. c(5,5,0) to downsample the first two dimensions but not the third.}

\item{pal}{Character vector of hex codes. Defaults to NULL, which selects the colorbrewer Set1 or viridis.}

\item{pal_na}{The hex code or name of the NA colour to be used.}

\item{pal_rev}{Reverses the palette. Defaults to FALSE.}

\item{pal_borders}{Colour of the borders. Defaults to "#7F7F7F".}

\item{alpha_fill}{The opacity of the fill. Defaults to 1.}

\item{alpha_borders}{Opacity of the borders. Defaults to 0.5.}

\item{size_borders}{Size of the borders. Defaults to 0.2.}

\item{title}{Title string.}

\item{title_wrap}{Number of characters to wrap the title to. Defaults to 75.}

\item{subtitle}{Subtitle string.}

\item{subtitle_wrap}{Number of characters to wrap the subtitle to. Defaults to 100. Not applicable where mobile equals TRUE.}

\item{col_breaks_n}{For a numeric colour variable, the desired number of intervals on the colour scale.}

\item{col_cuts}{A vector of cuts to colour a numeric variable. If "bin" is selected, the first number in the vector should be either -Inf or 0, and the final number Inf. If "quantile" is selected, the first number in the vector should be 0 and the final number should be 1. Defaults to quartiles.}

\item{col_intervals_left}{For a numeric colour variable, TRUE or FALSE of whether bins or quantiles are to be cut left-closed. Defaults to TRUE.}

\item{col_labels}{A function or named vector to modify colour scale labels. Defaults to snakecase::to_sentence_case for categorical colour variables and scales::comma for numeric colour variables. Use ggplot2::waiver() to keep colour labels untransformed.}

\item{col_legend_none}{TRUE or FALSE of whether to remove the legend.}

\item{col_na_rm}{TRUE or FALSE of whether to visualise col_var NA values. Defaults to FALSE.}

\item{col_method}{The method of colouring features, either "bin", "quantile", "continuous", or "category." If numeric, defaults to "bin".}

\item{col_title}{Colour title string for the legend. Defaults to NULL, which converts to sentence case with spaces. Use "" if you would like no title.}

\item{col_title_wrap}{Number of characters to wrap the colour title to. Defaults to 25. Not applicable where mobile equals TRUE.}

\item{caption}{Caption title string.}

\item{caption_wrap}{Number of characters to wrap the caption to. Defaults to 80.}

\item{theme}{A ggplot2 theme.}

\item{mobile}{Whether the plot is to be displayed on a mobile device. Defaults to FALSE.}
}
\value{
A ggplot object.
}
\description{
Map of an array in ggplot that is coloured, but not facetted.
}
\examples{
library(simplevis)

gg_stars_col(example_stars,
             col_var = nitrate,
             col_na_rm = TRUE,
             borders = example_borders)
          
}
