% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_hviolin.R
\name{gg_hviolin_col_facet}
\alias{gg_hviolin_col_facet}
\title{Horizontal violin ggplot that is coloured and facetted.}
\usage{
gg_hviolin_col_facet(
  data,
  x_var = NULL,
  y_var,
  col_var,
  facet_var,
  pal = NULL,
  pal_na = "#7F7F7F",
  pal_rev = FALSE,
  alpha_fill = 1,
  alpha_line = 1,
  size_line = 0.5,
  width = 0.75,
  title = NULL,
  title_wrap = 75,
  subtitle = NULL,
  subtitle_wrap = 75,
  x_breaks_n = 2,
  x_zero_mid = FALSE,
  x_expand = c(0, 0),
  x_labels = scales::label_comma(),
  x_title = NULL,
  x_title_wrap = 50,
  x_zero = FALSE,
  x_zero_line = NULL,
  y_expand = ggplot2::waiver(),
  y_labels = snakecase::to_sentence_case,
  y_na_rm = FALSE,
  y_rev = FALSE,
  y_title = NULL,
  y_title_wrap = 50,
  col_labels = stringr::str_to_sentence,
  col_legend_none = FALSE,
  col_na_rm = FALSE,
  col_rev = FALSE,
  col_title = NULL,
  col_title_wrap = 25,
  facet_labels = snakecase::to_sentence_case,
  facet_na_rm = FALSE,
  facet_ncol = NULL,
  facet_nrow = NULL,
  facet_rev = FALSE,
  facet_scales = "fixed",
  caption = NULL,
  caption_wrap = 75,
  theme = gg_theme(x_grid = TRUE),
  model_scale = "area",
  model_bw = "nrd0",
  model_adjust = 1,
  model_kernel = "gaussian",
  model_trim = TRUE
)
}
\arguments{
\item{data}{A data frame in a structure to be transformed to density statistics. Required input.}

\item{x_var}{Generally an unquoted numeric variable to be on the x scale. However if stat = "identity" is selected, a list-column with min, lower, middle, upper, and max variable names.}

\item{y_var}{Unquoted categorical variable to be on the y scale (i.e. character, factor, or logical). Required input.}

\item{col_var}{Unquoted categorical or numeric variable to colour the boxplots. Required input.}

\item{facet_var}{Unquoted categorical variable to facet the data by. Required input.}

\item{pal}{Character vector of hex codes.}

\item{pal_na}{The hex code or name of the NA colour to be used.}

\item{pal_rev}{TRUE or FALSE of whether to reverse the pal.}

\item{alpha_fill}{The opacity of the fill. Defaults to 1.}

\item{alpha_line}{The opacity of the outline. Defaults to 1.}

\item{size_line}{The size of the outlines of violins. Defaults to 0.5.}

\item{width}{Width of boxes. Defaults to 0.75.}

\item{title}{Title string.}

\item{title_wrap}{Number of characters to wrap the title to. Defaults to 60.}

\item{subtitle}{Subtitle string.}

\item{subtitle_wrap}{Number of characters to wrap the subtitle to. Defaults to 60.}

\item{x_breaks_n}{For a numeric or date x variable, the desired number of intervals on the x scale, as calculated by the pretty algorithm. Defaults to 5.}

\item{x_zero_mid}{For a numeric x variable, add balance to the x scale so that zero is in the centre of the x scale.}

\item{x_expand}{A vector of range expansion constants used to add padding to the x scale, as per the ggplot2 expand argument in ggplot2 scales functions.}

\item{x_labels}{A function or named vector to modify x scale labels. Use ggplot2::waiver() to keep x labels untransformed.}

\item{x_title}{X scale title string. Defaults to NULL, which converts to sentence case with spaces. Use "" if you would like no title.}

\item{x_title_wrap}{Number of characters to wrap the x title to. Defaults to 50.}

\item{x_zero}{For a numeric x variable, TRUE or FALSE of whether the minimum of the x scale is zero. Defaults to FALSE.}

\item{x_zero_line}{For a numeric x variable, TRUE or FALSE whether to add a zero reference line to the x scale. Defaults to TRUE if there are positive and negative values in x_var. Otherwise defaults to FALSE.}

\item{y_expand}{A vector of range expansion constants used to add padding to the y scale, as per the ggplot2 expand argument in ggplot2 scales functions.}

\item{y_labels}{A function or named vector to modify y scale labels. If NULL, categorical variable labels are converted to sentence case. Use ggplot2::waiver() to keep y labels untransformed.}

\item{y_na_rm}{TRUE or FALSE of whether to include y_var NA values. Defaults to FALSE.}

\item{y_rev}{For a categorical variable, TRUE or FALSE of whether the y variable variable is reversed. Defaults to FALSE.}

\item{y_title}{y scale title string. Defaults to NULL, which converts to sentence case with spaces. Use "" if you would like no title.}

\item{y_title_wrap}{Number of characters to wrap the y title to. Defaults to 50.}

\item{col_labels}{A function or named vector to modify colour scale labels. Defaults to snakecase::to_sentence_case for categorical colour variables and scales::number for numeric colour variables. Use ggplot2::waiver() to keep colour labels untransformed.}

\item{col_legend_none}{TRUE or FALSE of whether to remove the legend.}

\item{col_na_rm}{TRUE or FALSE of whether to include col_var NA values. Defaults to FALSE.}

\item{col_rev}{TRUE or FALSE of whether the colour scale is reversed. Defaults to FALSE.}

\item{col_title}{Colour title string for the legend. Defaults to NULL, which converts to sentence case with spaces. Use "" if you would like no title.}

\item{col_title_wrap}{Number of characters to wrap the colour title to. Defaults to 25. Not applicable where mobile equals TRUE.}

\item{facet_labels}{A function or named vector to modify facet scale labels. Defaults to converting labels to sentence case. Use ggplot2::waiver() to keep facet labels untransformed.}

\item{facet_na_rm}{TRUE or FALSE of whether to include facet_var NA values. Defaults to FALSE.}

\item{facet_ncol}{The number of columns of facetted plots.}

\item{facet_nrow}{The number of rows of facetted plots.}

\item{facet_rev}{TRUE or FALSE of whether the facet variable variable is reversed. Defaults to FALSE.}

\item{facet_scales}{Whether facet_scales should be "fixed" across facets, "free" in both directions, or free in just one direction (i.e. "free_x" or "free_y"). Defaults to "fixed".}

\item{caption}{Caption title string.}

\item{caption_wrap}{Number of characters to wrap the caption to. Defaults to 75.}

\item{theme}{A ggplot2 theme.}

\item{model_scale}{Per ggplot2::geom_violin, if "area" (default), all violins have the same area (before trimming the tails). If "count", areas are scaled proportionally to the number of observations. If "width", all violins have the same maximum width.}

\item{model_bw}{The bw argument of the stats::density function. Defaults to "nrd0".}

\item{model_adjust}{The adjust argument of the stats::density function. Defaults to 1.}

\item{model_kernel}{The kernel argument of the stats::density function. Defaults to "gaussian".}

\item{model_trim}{TRUE or FALSE of whether to trim the tails. Defaults to FALSE.}
}
\value{
A ggplot object.
}
\description{
Horizontal violin ggplot that is coloured and facetted.
}
\examples{
library(simplevis)
library(palmerpenguins)

penguins \%>\%
  dplyr::mutate(year = as.character(year)) \%>\%
  gg_hviolin_col_facet(x_var = body_mass_g,
                        y_var = year,
                        col_var = sex,
                        facet_var = species,
                        col_na_rm = TRUE)

}
