% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme.R
\name{theme_v_gridlines}
\alias{theme_v_gridlines}
\title{Theme for graphs with vertical gridlines.}
\usage{
theme_v_gridlines(font_family = "", font_size_title = 11, font_size_body = 10)
}
\arguments{
\item{font_family}{Font family to use. Defaults to "".}

\item{font_size_title}{Font size for the title text. Defaults to 11.}

\item{font_size_body}{Font size for all text other than the title. Defaults to 10.}
}
\value{
A ggplot theme.
}
\description{
Theme for graphs with vertical gridlines.
}
\examples{
library(simplevis)
library(ggplot2)

ggplot() +
  scale_x_continuous(breaks = seq(0, 10, 2), limits = c(0, 10), expand = c(0, 0)) +
  scale_y_continuous(breaks = seq(0, 10, 2), limits = c(0, 10), expand = c(0, 0)) +
  ggtitle("This is a title of a font family and size") +
  theme_v_gridlines("Courier", 9, 7) 
  
}
