% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_sf.R
\name{ggplot_sf_facet}
\alias{ggplot_sf_facet}
\title{Map of simple features in ggplot that is facetted.}
\usage{
ggplot_sf_facet(data, facet_var, text_var = NULL, size_point = 1,
  size_line = 0.5, alpha = 1, pal = NULL, facet_ncol = NULL,
  facet_nrow = NULL, borders = NULL, borders_behind = TRUE,
  borders_pal = "#7f7f7f", borders_size = 0.2, title = "[Title]",
  title_wrap = 70, subtitle = NULL, subtitle_wrap = 80,
  caption = NULL, caption_wrap = 80, font_family = "Helvetica",
  font_size_title = NULL, font_size_body = NULL)
}
\arguments{
\item{data}{A sf object with defined coordinate reference system. Required input.}

\item{facet_var}{Unquoted categorical variable to facet the data by. Required input.}

\item{text_var}{Unquoted variable to be used as a customised tooltip in combination with plotly::ggplotly(plot, tooltip = "text"). Defaults to NULL.}

\item{size_point}{Size of points. Defaults to 0.5.}

\item{size_line}{Size of lines. Defaults to 0.5.}

\item{alpha}{The alpha of the fill. Defaults to 1.}

\item{pal}{Character vector of hex codes. Defaults to NULL, which selects a default palette.}

\item{facet_ncol}{The number of columns of facetted plots.}

\item{facet_nrow}{The number of rows of facetted plots.}

\item{borders}{A sf object as administrative boundaries (or coastlines). Defaults to no boundaries added. The rnaturalearth package is a useful source of country and state boundaries.}

\item{borders_behind}{TRUE or FALSE  as to whether the borders is to be behind the sf object defined in the data argument. Defaults to TRUE.}

\item{borders_pal}{Colour of the borders. Defaults to "#7F7F7F".}

\item{borders_size}{Size of the borders. Defaults to 0.2.}

\item{title}{Title string. Defaults to "[Title]".}

\item{title_wrap}{Number of characters to wrap the title to. Defaults to 70.}

\item{subtitle}{Subtitle string. Defaults to "[Subtitle]".}

\item{subtitle_wrap}{Number of characters to wrap the subtitle to. Defaults to 80.}

\item{caption}{Caption title string. Defaults to NULL.}

\item{caption_wrap}{Number of characters to wrap the caption to. Defaults to 80.}

\item{font_family}{Font family to use. Defaults to "Helvetica".}

\item{font_size_title}{Font size for the title text. Defaults to 11.}

\item{font_size_body}{Font size for all text other than the title. Defaults to 10.}
}
\value{
A ggplot object.
}
\description{
Map of simple features in ggplot that is facetted, but not coloured.
}
\examples{
ggplot_sf_facet(data = example_sf_point, facet_var = trend_category, 
  borders = nz,
  title = "Trends, 1990-2017")
}
