% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_point.R
\name{ggplot_point_col_facet}
\alias{ggplot_point_col_facet}
\title{Point ggplot that is coloured and facetted.}
\usage{
ggplot_point_col_facet(data, x_var, y_var, col_var, facet_var,
  text_var = NULL, size_point = 1, pal = NULL, pal_rev = FALSE,
  title = "[Title]", title_wrap = 70, subtitle = NULL,
  subtitle_wrap = 80, x_balance = FALSE, x_expand = NULL,
  x_labels = waiver(), x_pretty_n = 5, x_title = "[X title]",
  x_title_wrap = 50, x_trans = "identity", x_zero = FALSE,
  x_zero_line = NULL, y_balance = FALSE, y_expand = NULL,
  y_labels = waiver(), y_pretty_n = 5, y_title = "[Y title]",
  y_title_wrap = 50, y_trans = "identity", y_zero = FALSE,
  y_zero_line = NULL, col_cuts = NULL, col_labels_dp = 1,
  col_labels = NULL, col_labels_ncol = NULL, col_labels_nrow = NULL,
  col_method = NULL, col_na = TRUE, col_quantile_by_facet = TRUE,
  col_title = "", col_title_wrap = 25, facet_ncol = NULL,
  facet_nrow = NULL, facet_scales = "fixed", caption = NULL,
  caption_wrap = 80, font_family = "Helvetica",
  font_size_title = NULL, font_size_body = NULL)
}
\arguments{
\item{data}{An ungrouped summarised tibble or dataframe. Required input.}

\item{x_var}{Unquoted numeric variable to be on the x axis. Required input.}

\item{y_var}{Unquoted numeric variable to be on the y axis. Required input.}

\item{col_var}{Unquoted variable for points to be coloured by. Required input.}

\item{facet_var}{Unquoted categorical variable to facet the data by. Required input.}

\item{text_var}{Unquoted variable to be used as a customised tooltip in combination with plotly::ggplotly(plot, tooltip = "text"). Defaults to NULL.}

\item{size_point}{Size of points. Defaults to 1.}

\item{pal}{Character vector of hex codes. Defaults to viridis. Use the pals package to find a suitable palette.}

\item{pal_rev}{Reverses the palette. Defaults to FALSE.}

\item{title}{Title string. Defaults to "[Title]".}

\item{title_wrap}{Number of characters to wrap the title to. Defaults to 70.}

\item{subtitle}{Subtitle string. Defaults to "[Subtitle]".}

\item{subtitle_wrap}{Number of characters to wrap the subtitle to. Defaults to 80.}

\item{x_balance}{Add balance to the x axis so that zero is in the centre of the x scale.}

\item{x_expand}{A vector of range expansion constants used to add some padding on the x scale.}

\item{x_labels}{Adjust the  x scale labels through a function or vector.}

\item{x_pretty_n}{The desired number of intervals on the x axis, as calculated by the pretty algorithm. Defaults to 5.}

\item{x_title}{X axis title string. Defaults to "[X title]".}

\item{x_title_wrap}{Number of characters to wrap the x title to. Defaults to 50.}

\item{x_trans}{A string specifying a transformation for the x scale. Defaults to "identity".}

\item{x_zero}{TRUE or FALSE whether the minimum of the x scale is zero. Defaults to TRUE.}

\item{x_zero_line}{TRUE or FALSE whether to add a zero reference line to the x axis. TRUE if there are positive and negative values in x_var. Otherwise defaults to FALSE.}

\item{y_balance}{Add balance to the y axis so that zero is in the centre of the y scale.}

\item{y_expand}{A vector of range expansion constants used to add some padding on the y scale.}

\item{y_labels}{Adjust the  y scale labels through a function or vector.}

\item{y_pretty_n}{The desired number of intervals on the y axis, as calculated by the pretty algorithm. Defaults to 5.}

\item{y_title}{Y axis title string. Defaults to "[Y title]".}

\item{y_title_wrap}{Number of characters to wrap the y title to. Defaults to 50.}

\item{y_trans}{A string specifying a transformation for the y scale. Defaults to "identity".}

\item{y_zero}{TRUE or FALSE whether the minimum of the y scale is zero. Defaults to FALSE.}

\item{y_zero_line}{TRUE or FALSE whether to add a zero reference line to the y axis. TRUE if there are positive and negative values in y_var. Otherwise defaults to FALSE.}

\item{col_cuts}{A vector of cuts to colour a numeric variable. If "bin" is selected, the first number in the vector should be either -Inf or 0, and the final number Inf. If "quantile" is selected, the first number in the vector should be 0 and the final number should be 1. Defaults to quartiles.}

\item{col_labels_dp}{Select the appropriate number of decimal places for numeric variable auto legend labels. Defaults to 1.}

\item{col_labels}{Adjust the colour scale labels through a vector.}

\item{col_labels_ncol}{The number of columns in the legend.}

\item{col_labels_nrow}{The number of rows in the legend.}

\item{col_method}{The method of colouring features, either "bin", "quantile" or "category." If numeric, defaults to "quantile".}

\item{col_na}{TRUE or FALSE of whether to show NA values of the colour variable. Defaults to TRUE.}

\item{col_quantile_by_facet}{TRUE of FALSE whether quantiles should be calculated for each group of the facet variable. Defaults to TRUE.}

\item{col_title}{Colour title string for the legend. Defaults to NULL.}

\item{col_title_wrap}{Number of characters to wrap the colour title to. Defaults to 25.}

\item{facet_ncol}{The number of columns of facetted plots.}

\item{facet_nrow}{The number of rows of facetted plots.}

\item{facet_scales}{Whether facet_scales should be "fixed" across facets, "free" in both directions, or free in just one direction (i.e. "free_x" or "free_y"). Defaults to "fixed".}

\item{caption}{Caption title string. Defaults to NULL.}

\item{caption_wrap}{Number of characters to wrap the caption to. Defaults to 80.}

\item{font_family}{Font family to use. Defaults to "Helvetica".}

\item{font_size_title}{Font size for the title text. Defaults to 11.}

\item{font_size_body}{Font size for all text other than the title. Defaults to 10.}
}
\value{
A ggplot object.
}
\description{
Point ggplot that is coloured and facetted.
}
\examples{
library(dplyr)

plot_data <- ggplot2::diamonds \%>\%
  sample_frac(0.05) \%>\%
  mutate(cut = stringr::str_to_sentence(cut))

ggplot_point_col_facet(plot_data, carat, price, color, cut)

}
