% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_stars_fun.R
\name{ggplot_stars}
\alias{ggplot_stars}
\title{Map of an array in ggplot.}
\usage{
ggplot_stars(data, pal = NULL, title = "[Title]", subtitle = NULL,
  caption = NULL, font_family = "Helvetica", font_size_title = NULL,
  font_size_body = NULL, title_wrap = 70, subtitle_wrap = 80,
  caption_wrap = 80, isMobile = FALSE)
}
\arguments{
\item{data}{A stars object with 2 dimensions x and y. Required input.}

\item{pal}{Character vector of hex codes, or provided objects with pal_ prefixes.}

\item{title}{Title string. Defaults to "[Title]".}

\item{subtitle}{Subtitle string. Defaults to "[Subtitle]".}

\item{caption}{Caption title string. Defaults to NULL.}

\item{font_family}{Font family to use. Defaults to "Helvetica".}

\item{font_size_title}{Font size for the title text. Defaults to 11.}

\item{font_size_body}{Font size for all text other than the title. Defaults to 10.}

\item{title_wrap}{Number of characters to wrap the title to. Defaults to 70. Not applicable where isMobile equals TRUE.}

\item{subtitle_wrap}{Number of characters to wrap the subtitle to. Defaults to 80. Not applicable where isMobile equals TRUE.}

\item{caption_wrap}{Number of characters to wrap the caption to. Defaults to 80. Not applicable where isMobile equals TRUE.}

\item{isMobile}{Whether the plot is to be displayed on a mobile device. Defaults to FALSE. If within an app with the mobileDetect function, then use isMobile = input$isMobile.}
}
\value{
A ggplot object.
}
\description{
Map of an array in ggplot that is not coloured and not facetted.
}
\examples{
ggplot_stars(data = example_stars)
}
