# leaflet basemap stack functions

#' @title Basemap stack in leaflet.
#' @description Make a stack of leaflet baselayers for use in shiny apps.
#' @param top_layer The first layer to start in the basemap stack. Either "light", "dark", "street", "satellite", or "ocean". Defaults to "light".
#' @return A leaflet object.
#' @export
#' @examples
#' leaflet_basemap("dark")

leaflet_basemap <- function(top_layer = "light"){
  
  if(top_layer == "light") basemap_order <- c("Light", "Dark", "Street", "Satellite", "Ocean")
  else if(top_layer == "dark") basemap_order <- c("Dark", "Light", "Street", "Satellite", "Ocean")
  else if(top_layer == "satellite") basemap_order <- c("Satellite", "Light", "Dark", "Street", "Ocean")
  else if(top_layer == "street") basemap_order <- c("Street", "Light", "Dark", "Satellite", "Ocean")
  else if(top_layer == "ocean") basemap_order <- c("Ocean", "Light", "Dark", "Street", "Satellite")
  else basemap_order <- c("Light", "Dark", "Street", "Satellite", "Ocean")
  
  providers <- leaflet::providers
  
  leaflet() %>%
    # leaflet.extras::addFullscreenControl() %>%
    leaflet.extras::addResetMapButton() %>%
    addProviderTiles(
      providers$CartoDB.PositronNoLabels,
      group = "Light",
      options = providerTileOptions(zIndex = 0, attribution = "\u00A9 CartoDB")
    ) %>%
    addProviderTiles(
      providers$Esri.WorldImagery,
      group = "Satellite",
      options = providerTileOptions(zIndex = 0, attribution = "\u00A9 ESRI")
    ) %>%
    addProviderTiles(
      providers$Esri.OceanBasemap,
      group = "Ocean",
      options = providerTileOptions(zIndex = 0, attribution = "\u00A9 ESRI")
    ) %>%
    addProviderTiles(
      providers$OpenStreetMap.Mapnik,
      group = "Street",
      options = providerTileOptions(zIndex = 0, attribution = "\u00A9 OpenStreetMap")
    ) %>%
    addProviderTiles(
      providers$CartoDB.DarkMatterNoLabels,
      group = "Dark",
      options = providerTileOptions(zIndex = 0, attribution = "\u00A9 CartoDB")
    ) %>%
    addLayersControl(
      baseGroups = basemap_order,
      position = "topleft",
      options = layersControlOptions(autoZIndex = FALSE)
    )
  
}

#' @title Basemap stack in leaflet for New Zealand.
#' @description Make a stack of leaflet baselayers for use in New Zealand focussed shiny apps.
#' @param top_layer The first layer to start in the basemap stack. Either "light", "dark", "street", "satellite", or "ocean". Defaults to "light".
#' @return A leaflet object.
#' @export
#' @examples
#' leaflet_basemap_nz("dark")

leaflet_basemap_nz <- function(top_layer = "light"){
  
  if(top_layer == "light") basemap_order <- c("Light", "Dark", "Street", "Satellite", "Ocean")
  else if(top_layer == "dark") basemap_order <- c("Dark", "Light", "Street", "Satellite", "Ocean")
  else if(top_layer == "satellite") basemap_order <- c("Satellite", "Light", "Dark", "Street", "Ocean")
  else if(top_layer == "street") basemap_order <- c("Street", "Light", "Dark", "Satellite", "Ocean")
  else if(top_layer == "ocean") basemap_order <- c("Ocean", "Light", "Dark", "Street", "Satellite")
  else basemap_order <- c("Light", "Dark", "Street", "Satellite", "Ocean")
  
  providers <- leaflet::providers
  
  leaflet() %>%
    fitBounds(166.70047,-34.45676, 178.52966,-47.06345) %>%
    leaflet.extras::addResetMapButton() %>%
    addProviderTiles(
      providers$CartoDB.PositronNoLabels,
      group = "Light",
      options = providerTileOptions(zIndex = 0, attribution = "\u00A9 CartoDB")
    ) %>%
    addProviderTiles(
      providers$Esri.WorldImagery,
      group = "Satellite",
      options = providerTileOptions(zIndex = 0, attribution = "\u00A9 ESRI")
    ) %>%
    addProviderTiles(
      providers$Esri.OceanBasemap,
      group = "Ocean",
      options = providerTileOptions(zIndex = 0, attribution = "\u00A9 ESRI")
    ) %>%
    addProviderTiles(
      providers$OpenStreetMap.Mapnik,
      group = "Street",
      options = providerTileOptions(zIndex = 0, attribution = "\u00A9 OpenStreetMap")
    ) %>%
    addProviderTiles(
      providers$CartoDB.DarkMatterNoLabels,
      group = "Dark",
      options = providerTileOptions(zIndex = 0, attribution = "\u00A9 CartoDB")
    ) %>%
    addLayersControl(
      baseGroups = basemap_order,
      position = "topleft",
      options = layersControlOptions(autoZIndex = FALSE)
    ) 
}
