% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_hbar_fun.R
\name{ggplot_hbar_facet}
\alias{ggplot_hbar_facet}
\title{Horizontal bar ggplot that is facetted.}
\usage{
ggplot_hbar_facet(data, x_var, y_var, facet_var, tip_var = NULL,
  x_labels = waiver(), x_zero = TRUE, x_zero_line = TRUE,
  x_trans = "identity", x_pretty_n = 5, y_rev = FALSE,
  y_labels = waiver(), facet_scales = "fixed", facet_nrow = NULL,
  pal = NULL, width = 0.75, title = "[Title]", na_grey = FALSE,
  subtitle = NULL, x_title = "[X title]", y_title = "[Y title]",
  caption = NULL, font_family = "Helvetica", font_size_title = NULL,
  font_size_body = NULL, wrap_title = 70, wrap_subtitle = 80,
  wrap_x_title = 50, wrap_y_title = 50, wrap_caption = 80,
  isMobile = FALSE)
}
\arguments{
\item{data}{A tibble or dataframe. Required input.}

\item{x_var}{Unquoted numeric variable to be on the x axis. Required input.}

\item{y_var}{Unquoted categorical variable to be on the y axis. Required input.}

\item{facet_var}{Unquoted categorical variable to facet the data by. Required input.}

\item{tip_var}{Unquoted variable to be used as a customised tooltip in combination with plotly::ggplotly(plot). Defaults to NULL.}

\item{x_labels}{Argument to adjust the format of the x scale labels.}

\item{x_zero}{TRUE or FALSE whether the minimum of the x scale is zero. Defaults to TRUE.}

\item{x_zero_line}{TRUE or FALSE whether to add a zero line in for when values are above and below zero. Defaults to TRUE.}

\item{x_trans}{A string specifying a transformation for the x scale. Defaults to "identity".}

\item{x_pretty_n}{The desired number of intervals on the x axis, as calculated by the pretty algorithm. Defaults to 5. Not applicable where isMobile equals TRUE.}

\item{y_rev}{TRUE or FALSE of whether bar order from top to bottom is reversed from default. Defaults to FALSE.}

\item{y_labels}{Argument to adjust the format of the y scale labels.}

\item{facet_scales}{Whether facet_scales should be "fixed" across facets, "free" in both directions, or free in just one direction (i.e. "free_x" or "free_y"). Defaults to "fixed".}

\item{facet_nrow}{The number of rows of facetted plots. Defaults to NULL, which generally chooses 2 rows. Not applicable to where isMobile is TRUE.}

\item{pal}{Character vector of hex codes. Defaults to NULL, which selects the Stats NZ palette.}

\item{width}{Width of bars. Defaults to 0.75.}

\item{title}{Title string. Defaults to [Title].}

\item{na_grey}{TRUE or FALSE of whether to provide wide grey bars for NA y_var values. Defaults to FALSE. Only applicable where facet_scales = "fixed" or "free_y".}

\item{subtitle}{Subtitle string. Defaults to [Subtitle].}

\item{x_title}{X axis title string. Defaults to [X title].}

\item{y_title}{Y axis title string. Defaults to [Y title].}

\item{caption}{Caption title string. Defaults to NULL.}

\item{font_family}{Font family to use. Defaults NULL.}

\item{font_size_title}{Font size for the title text. Defaults to 11.}

\item{font_size_body}{Font size for all text other than the title. Defaults to 10.}

\item{wrap_title}{Number of characters to wrap the title to. Defaults to 70. Not applicable where isMobile equals TRUE.}

\item{wrap_subtitle}{Number of characters to wrap the subtitle to. Defaults to 80. Not applicable where isMobile equals TRUE.}

\item{wrap_x_title}{Number of characters to wrap the x title to. Defaults to 50. Not applicable where isMobile equals TRUE.}

\item{wrap_y_title}{Number of characters to wrap the y title to. Defaults to 50. Not applicable where isMobile equals TRUE.}

\item{wrap_caption}{Number of characters to wrap the caption to. Defaults to 80. Not applicable where isMobile equals TRUE.}

\item{isMobile}{Whether the plot is to be displayed on a mobile device. Defaults to FALSE. If within an app with the mobileDetect function, then use isMobile = input$isMobile.}
}
\value{
A ggplot object.
}
\description{
Horizontal bar ggplot that is facetted, but not coloured.
}
\examples{
library(dplyr)

plot_data <- ggplot2::diamonds \%>\%
  mutate(cut = stringr::str_to_sentence(cut)) \%>\%
  group_by(cut, clarity) \%>\%
  summarise(average_price = mean(price)) \%>\%
  mutate(average_price_thousands = round(average_price / 1000, 1)) 

plot <- ggplot_hbar_facet(data = plot_data, x_var = average_price_thousands,
                          y_var = cut, facet_var = clarity,
                         title = "Average diamond price by cut and clarity", 
                         x_title = "Average price ($US thousands)", 
                         y_title = "Cut")

plot

plotly::ggplotly(plot)
}
