% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simmer-methods.R
\name{add_dataframe}
\alias{add_dataframe}
\title{Add a Data Frame}
\usage{
add_dataframe(.env, name_prefix, trajectory, data, mon = 1, batch = 50,
  col_time = "time", time = c("interarrival", "absolute"),
  col_attributes = NULL, col_priority = "priority",
  col_preemptible = col_priority, col_restart = "restart")
}
\arguments{
\item{.env}{the simulation environment.}

\item{name_prefix}{the name prefix of the generated arrivals.}

\item{trajectory}{the trajectory that the generated arrivals will follow (see
\code{\link{trajectory}}).}

\item{data}{a data frame with, at least, a column of (inter)arrival times (see details).}

\item{mon}{whether the simulator must monitor the generated arrivals or not
(0 = no monitoring, 1 = simple arrival monitoring, 2 = level 1 + arrival
attribute monitoring)}

\item{batch}{number of arrivals generated at a time. Arrivals are read from
the data frame and attached to the trajectory in batches depending on this
value. In general, it should not be changed.}

\item{col_time}{name of the time column in the data frame.}

\item{time}{type of time column: \emph{interarrival}, if the time column
contains interarrival times, or \emph{absolute}, if the time column contains
absolute arrival times.}

\item{col_attributes}{vector of names of the attributes columns (see details).}

\item{col_priority}{name of the priority column.}

\item{col_preemptible}{name of the preemptible column.}

\item{col_restart}{name of the restart column.}
}
\value{
Returns the simulation environment.
}
\description{
Attach a new source of arrivals to a trajectory from a data frame.
}
\details{
The data frame provided must have, at least, a column of (inter)arrival
times. This method will look for it under the name \code{"time"} by default,
although this can be changed with the \code{col_time} parameter.

If there is any column named \code{col_priority="priority"},
\code{col_preemptible=priority} or \code{col_restart="restart"}, they will be
used to set the prioritization values for each arrival (see \code{\link{add_generator}}).

If there are additional columns (with \code{col_attributes=NULL}, by default),
they will be assigned to arrival attributes named after each column name. All
these columns must be numeric (or logical). Otherwise, if a vector of column
names is specified, only these will be assigned as attributes and the rest of
the columns will be ignored.

A value of \code{batch=Inf} means that the whole data frame will be attached
at the beginning of the simulation. This is not desirable in general, because
the performance of the event queue is degraded when it is populated with too
many events. On the other hand, a low value results in an increased overhead
due to many function calls. The default value has been tested to provide a
good trade-off.
}
\seealso{
Other sources: \code{\link{add_generator}}.
}
