% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectory-activities.R
\name{renege}
\alias{renege}
\alias{leave}
\alias{renege_in}
\alias{renege_if}
\alias{renege_abort}
\title{Renege on some Condition}
\usage{
leave(.trj, prob, out = NULL, keep_seized = TRUE)

renege_in(.trj, t, out = NULL, keep_seized = FALSE)

renege_if(.trj, signal, out = NULL, keep_seized = FALSE)

renege_abort(.trj)
}
\arguments{
\item{.trj}{the trajectory object.}

\item{prob}{a probability or a function returning a probability.}

\item{out}{optional sub-trajectory in case of reneging.}

\item{keep_seized}{whether to keep already seized resources. By default, all
resources are released.}

\item{t}{timeout to trigger reneging, accepts either a numeric or a callable
object (a function) which must return a numeric.}

\item{signal}{signal to trigger reneging, accepts either a string or a
callable object (a function) which must return a string.}
}
\value{
Returns the trajectory object.
}
\description{
Activities for leaving with some probability, or for setting or unsetting a
timer or a signal after which the arrival will abandon.
}
\details{
Arrivals that leave the trajectory will set the \code{finished} flag
to \code{FALSE} in the output of \code{\link{get_mon_arrivals}}. Unfinished
arrivals can be handled with a drop-out trajectory that can be set using the
optional argument \code{out} or the \code{\link{handle_unfinished}} activity.

Note that, for historical reasons, \code{leave} has \code{keep_seized=TRUE}
by default, while \code{renege_*} does not.

Note that \code{renege_if} works similarly to \code{\link{trap}},
but in contrast to that, reneging is triggered even if the arrival is waiting
in a queue or is part of a non-permanent \code{\link{batch}}.
}
\examples{
## leave with some probability
set.seed(1234)

traj <- trajectory() \%>\%
  log_("leave with some probability") \%>\%
  leave(function() runif(1) < 0.5) \%>\%
  log_("didn't leave")

simmer() \%>\%
  add_generator("dummy", traj, at(0, 1)) \%>\%
  run() \%>\% invisible

## reneging after some time
bank <- trajectory() \%>\%
  log_("here I am") \%>\%
  # renege in 5 minutes
  renege_in(
    5,
    out = trajectory() \%>\%
      log_("lost my patience. Reneging...")) \%>\%
  seize("clerk") \%>\%
  # stay if I'm being attended within 5 minutes
  renege_abort() \%>\%
  log_("I'm being attended") \%>\%
  timeout(10) \%>\%
  release("clerk") \%>\%
  log_("finished")

simmer() \%>\%
  add_resource("clerk", 1) \%>\%
  add_generator("customer", bank, at(0, 1)) \%>\%
  run() \%>\% invisible

}
\seealso{
\code{\link{handle_unfinished}}

\code{\link{send}}
}
