% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectory-activities.R
\name{set_attribute}
\alias{set_attribute}
\alias{set_global}
\title{Set Attributes}
\usage{
set_attribute(.trj, keys, values, global = FALSE, mod = c(NA, "+",
  "*"), init = 0)

set_global(.trj, keys, values, mod = c(NA, "+", "*"), init = 0)
}
\arguments{
\item{.trj}{the trajectory object.}

\item{keys}{the attribute name(s), or a callable object (a function) which
must return attribute name(s).}

\item{values}{numeric value(s) to set, or a callable object (a function) which
must return numeric value(s).}

\item{global}{\code{global=TRUE} is deprecated. Use \code{*_global} instead.}

\item{mod}{if set, \code{values} modify the attributes rather than substituting them.}

\item{init}{initial value, applied if \code{mod} is set and the attribute was
not previously initialised. Useful for counters or indexes.}
}
\value{
Returns the trajectory object.
}
\description{
Activity for modifying an arrival's attributes.
}
\seealso{
\code{\link{get_attribute}}, \code{\link{get_global}},
\code{\link{timeout_from_attribute}}, \code{\link{timeout_from_global}}.
}
