% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience_funcs.R
\name{from}
\alias{from}
\title{Generate arrivals starting at a specified time}
\usage{
from(start_time, dist, arrive = TRUE)
}
\arguments{
\item{start_time}{the time at which to launch the initial arrival}

\item{dist}{a function modelling the interarrival times (returning a negative value stops the generator).}

\item{arrive}{if set to \code{TRUE} (default) the first arrival will be generated at \code{start_time} and will follow \code{dist} from then on. If set to \code{FALSE}, will initiate \code{dist} at \code{start_time} (and the first arrival will most likely start at a time later than \code{start_time}).}
}
\value{
Returns a generator function.
}
\description{
Generator convenience function to generate inter arrivals with a specified initial start time.
}
\examples{
t0 <- create_trajectory("my trajectory") \%>\%
  ## add an intake activity
  seize("nurse", 1) \%>\%
  timeout(function() rnorm(1, 15)) \%>\%
  release("nurse", 1) \%>\%
  ## add a consultation activity
  seize("doctor", 1) \%>\%
  timeout(function() rnorm(1, 20)) \%>\%
  release("doctor", 1) \%>\%
  ## add a planning activity
  seize("administration", 1) \%>\%
  timeout(function() rnorm(1, 5)) \%>\%
  release("administration", 1)
  
env <- simmer("SuperDuperSim") \%>\%
  add_resource("nurse", 1) \%>\%
  add_resource("doctor", 2) \%>\%
  add_resource("administration", 1) \%>\%
  add_generator("patient", t0, from(5, function() rnorm(1, 10)))
}
\seealso{
\link{add_generator}
}

