% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_absolute.R
\name{calc_absolute}
\alias{calc_absolute}
\title{Calculate absolute performance criteria and MCSE}
\usage{
calc_absolute(
  res_dat,
  estimates,
  true_param,
  perfm_criteria = c("bias", "variance", "mse", "rmse")
)
}
\arguments{
\item{res_dat}{data frame or tibble containing the simulation results.}

\item{estimates}{name of the column containing the estimates.}

\item{true_param}{name of the column containing the true parameters.}

\item{perfm_criteria}{character or character vector indicating the performance criteria to be calculated.}
}
\value{
A tibble containing the number of simulation iterations, performance criteria estimate(s)
and the associated MCSE.
}
\description{
Calculates absolute bias, variance, mean squared error (mse)
and root mean squared error (rmse). The function also calculates the associated
Monte Carlo standard errors.
}
\examples{
calc_absolute(res_dat = t_res, estimates = est, true_param = true_param)


}
