% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization_utilities.R
\name{plot_estimated_cor_network}
\alias{plot_estimated_cor_network}
\title{Visualize estimated correlation matrix as a network}
\usage{
plot_estimated_cor_network(
  obj,
  n_obs = 1e+05,
  cor_type = "pearson",
  seed = NULL,
  show_categorical = TRUE,
  return_network = FALSE,
  ...
)
}
\arguments{
\item{obj}{S3 class object of type \code{simdesign} (or inheriting from it).}

\item{n_obs}{Number of observations to simulate.}

\item{cor_type}{Can be either a character (\code{pearson}, \code{spearman}, \code{kendall}) which is
passed to \code{\link[stats:cor]{stats::cor}} or a function, which is
directly used to compute the correlation matrix on the simulated data.
Such a function is expected to take a single input matrix (and possibly other
arguments which can be set via \code{...}) and output a single matrix.}

\item{seed}{Random number seed. NULL does not change the current seed.}

\item{show_categorical}{If TRUE, marks categorical variables differently from numeric ones.
Determined by the \code{types_final} slot of the \code{obj} argument.}

\item{return_network}{If TRUE, the \code{igraph} network object is returned and can be plotted by
the user using e.g. the interactive \code{\link[igraph:tkplot]{igraph::tkplot}}
function.}

\item{...}{Passed to \code{\link{plot_cor_network}}.}
}
\value{
If \code{return_network} is \code{TRUE}, then an \code{igraph} network object is returned
that can be plotted by the user using e.g. the interactive
\code{\link[igraph:tkplot]{igraph::tkplot}} function. Otherwise, the network
object is plotted directly and no output is returned.
}
\description{
Based on approximation via simulation specified by given simulation design.
Convenience wrapper for combining \code{\link{estimate_final_correlation}} and
\code{\link{plot_cor_network}}.
}
\details{
This function is useful to estimate the correlation network of a simulation
setup after the initial underlying distribution \code{Z} has been transformed to
the final dataset \code{X}.
}
\seealso{
\code{\link{plot_cor_network}},
\code{\link{estimate_final_correlation}}
}
