% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{as.data.frame.simstatespace}
\alias{as.data.frame.simstatespace}
\title{Coerce an Object of Class \code{simstatespace} to a Data Frame}
\usage{
\method{as.data.frame}{simstatespace}(
  x,
  row.names = NULL,
  optional = FALSE,
  eta = FALSE,
  long = TRUE,
  ...
)
}
\arguments{
\item{x}{Object of class \code{simstatespace}.}

\item{row.names}{\code{NULL} or character vector giving the row names
for the data frame.
Missing values are not allowed.}

\item{optional}{Logical.
If \code{TRUE}, setting row names and converting column names is optional.}

\item{eta}{Logical.
If \code{eta = TRUE}, include \code{eta}.
If \code{eta = FALSE}, exclude \code{eta}.}

\item{long}{Logical.
If \code{long = TRUE}, use long format.
If \code{long = FALSE}, use wide format.}

\item{...}{Additional arguments.}
}
\description{
Coerce an Object of Class \code{simstatespace} to a Data Frame
}
\examples{
# prepare parameters
set.seed(42)
k <- p <- 3
iden <- diag(k)
null_vec <- rep(x = 0, times = k)
n <- 5
mu0 <- null_vec
sigma0 <- iden
alpha <- null_vec
beta <- diag(x = 0.50, nrow = k)
psi <- iden
nu <- null_vec
lambda <- iden
theta <- diag(x = 0.50, nrow = k)
time <- 50
burn_in <- 0
gamma_y <- gamma_eta <- 0.10 * diag(k)
x <- lapply(
  X = seq_len(n),
  FUN = function(i) {
    return(
      matrix(
        data = rnorm(n = k * (time + burn_in)),
        ncol = k
      )
    )
  }
)

# Type 0
ssm <- SimSSMFixed(
  n = n,
  mu0 = mu0,
  sigma0 = sigma0,
  alpha = alpha,
  beta = beta,
  psi = psi,
  nu = nu,
  lambda = lambda,
  theta = theta,
  type = 0,
  time = time,
  burn_in = burn_in
)

head(as.data.frame(ssm))
head(as.data.frame(ssm, long = FALSE))

}
\author{
Ivan Jacob Agaloos Pesigan
}
\keyword{methods}
