% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipu2.r
\name{ipu2}
\alias{ipu2}
\alias{computeLinear}
\alias{computeFrac}
\alias{computeLinear}
\alias{computeFrac}
\title{Iterative Proportional Updating}
\usage{
ipu2(dat, hid = NULL, conP = NULL, conH = NULL, epsP = 1e-06,
  epsH = 0.01, verbose = FALSE, w = NULL, bound = 4, maxIter = 200,
  meanHH = TRUE, returnNA = TRUE, looseH = FALSE,
  numericalWeighting = computeLinear)

computeLinear(curValue, Value, numericVar, weightVec, boundLinear = 10)

computeFrac(curValue, Value, numericVar, weightVec)
}
\arguments{
\item{dat}{a \code{data.table} containing household ids (optionally), base
weights (optionally), household and/or personal level variables (numerical
or categorical) that should be fitted.}

\item{hid}{character vector specifying the variable containing household-ids
within \code{dat} or NULL if such a variable does not exist.}

\item{conP}{list or (partly) named list defining the constraints on person
level.  The list elements are contingency tables in array representation
with dimnames corresponding to the names of the relevant calibration
variables in \code{dat}. If a numerical variable is to be calibrated, the
respective list element has to be named with the name of that numerical
variable. Otherwise the list element shoud NOT be named.}

\item{conH}{list or (partly) named list defining the constraints on
household level.  The list elements are contingency tables in array
representation with dimnames corresponding to the names of the relevant
calibration variables in \code{dat}. If a numerical variable is to be
calibrated, the respective list element has to be named with the name of
that numerical variable. Otherwise the list element shoud NOT be named.}

\item{epsP}{numeric value or list (of numeric values and/or arrays)
specifying the convergence limit(s) for \code{conP}. The list can contain
numeric values and/or arrays which must appear in the same order as the
corresponding constraints in \code{conP}. Also, an array must have the same
dimensions and dimnames as the corresponding constraint in \code{conP}.}

\item{epsH}{numeric value or list (of numeric values and/or arrays)
specifying the convergence limit(s) for \code{conH}. The list can contain
numeric values and/or arrays which must appear in the same order as the
corresponding constraints in \code{conH}. Also, an array must have the same
dimensions and dimnames as the corresponding constraint in \code{conH}.}

\item{verbose}{if TRUE, some progress information will be printed.}

\item{w}{character vector specifying the variable containing the base
weights within \code{dat} or NULL if such a variable does not exist. In the
latter case, every observation in \code{dat} is assigned a starting weight
of 1.}

\item{bound}{numeric value specifying the multiplier for determining the
weight trimming boundary if the change of the base weights should be
restricted, i.e. if the weights should stay between 1/\code{bound}*\code{w}
and \code{bound}*\code{w}.}

\item{maxIter}{numeric value specifying the maximum number of iterations
that should be performed.}

\item{meanHH}{if TRUE, every person in a household is assigned the mean of
the person weights corresponding to the household.}

\item{returnNA}{if TRUE, the calibrated weight will be set to NA in case of no convergence.}

\item{looseH}{if FALSE, the actual constraints \code{conH} are used for calibrating all the hh weights. 
If TRUE, only the weights for which the lower and upper thresholds defined by \code{conH} and \code{epsH} are exceeded
are calibrated. They are however not calibrated against the actual constraints \code{conH} but against
these lower and upper thresholds, i.e. \code{conH}-\code{conH}*\code{epsH} and \code{conH}+\code{conH}*\code{epsH}.}

\item{numericalWeighting}{...}

\item{curValue}{the current value of the group total}

\item{Value}{the target group total}

\item{numericVar}{vector with the values of the numeric variable}

\item{weightVec}{vector with the current weights}

\item{boundLinear}{the result of computeLinear will be bound by \code{1/boundLinear} and \code{boundLinear}}
}
\value{
The function will return the input data \code{dat} with the
calibrated weights \code{calibWeight} as an additional column.
}
\description{
Adjust sampling weights to given totals based on household-level and/or
individual level constraints.
}
\examples{
data(eusilcS)
setDT(eusilcS)
eusilcS <- eusilcS[, list(db030,hsize,db040,age,rb090,netIncome,db090,rb050)]

## some recoding
# generate age groups
eusilcS[age<0, age:=0]
eusilcS[,agegroup:=floor(age/10)]
# some recoding of netIncome for reasons of simplicity
eusilcS[is.na(netIncome), netIncome:=0] 
eusilcS[netIncome<0, netIncome:=0] 
# set hsize to 1,...,5+
eusilcS[hsize>=5, hsize:=5] 

## example for base weights assuming a simple random sample of households stratified per region
eusilcS[, regSamp:=.N, by=db040]
eusilcS[, regPop:=sum(rb050), by=db040]
eusilcS[, baseWeight:=regPop/regSamp]

## constraints on person level
# age 
conP1 <- xtabs(V1 ~ agegroup, data=eusilcS[,sum(rb050),by=agegroup])
# gender by region
conP2 <- xtabs(V1 ~ rb090+db040, data=eusilcS[,sum(rb050),by=list(rb090,db040)])
# personal net income by gender
conP3 <- xtabs(V1 ~ rb090, data=eusilcS[,sum(rb050*netIncome),by=rb090])
## constraints on household level
conH1 <- xtabs(V1 ~ hsize+db040, data=eusilcS[!duplicated(db030),sum(rb050),list(hsize,db040)])

# array of convergence limits for conH1
epsH1 <- conH1
epsH1[as.character(1:4),] <- 0.005
epsH1["5",] <- 0.2

# without array epsP1
calibweights1 <- ipu2(eusilcS, hid = "db030", 
                      conP = list(conP1,conP2,netIncome=conP3), 
                      conH = list(conH1), 
                      epsP = list(1e-06,1e-06,1e-03),
                      epsH = 0.01,  
                      bound = NULL, verbose=TRUE,  maxIter = 200)

# with array epsP1, base weights and bound
calibweights2 <- ipu2(eusilcS, hid = "db030", 
                      conP = list(conP1,conP2), 
                      conH = list(conH1), 
                      epsP = 1e-06,
                      epsH = list(epsH1),  
                      w="baseWeight",
                      bound = 4, verbose=TRUE,  maxIter = 200)
}
\seealso{
\code{\link{ipu}}
}
\author{
Alexander Kowarik
}
