% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meanWt.R
\name{weighted_estimators}
\alias{corWt}
\alias{covWt}
\alias{meanWt}
\alias{varWt}
\alias{weighted_estimators}
\title{Weighted mean, variance, covariance matrix and correlation matrix}
\usage{
meanWt(x, ...)

varWt(x, ...)

covWt(x, ...)

corWt(x, ...)
}
\arguments{
\item{x}{for \code{meanWt} and \code{varWt}, a numeric vector or an object
of class \code{\linkS4class{dataObj}}. For \code{covWt} and \code{corWt}, a
numeric vector, matrix, \code{data.frame} or \code{\linkS4class{dataObj}}.
In case of a \code{\linkS4class{dataObj}}, weights are automatically used
from the S4-object itself.}

\item{\dots}{for the generic functions \code{covWt} and \code{corWt},
additional arguments to be passed to methods.  Additional arguments not
included in the definition of the methods are ignored.}
}
\value{
For \code{meanWt}, the (weighted) mean.

For \code{varWt}, the (weighted) variance.

For \code{covWt}, the (weighted) covariance matrix or, for the default
method, the (weighted) covariance.

For \code{corWt}, the (weighted) correlation matrix or, for the default
method, the (weighted) correlation coefficient.
}
\description{
Compute mean, variance, covariance matrix and correlation matrix, taking
into account sample weights.
\itemize{
\item \code{meanWt}: a simple wrapper that calls \code{mean(x, na.rm=na.rm)} if
\code{weights} is missing and \code{weighted.mean(x, w=weights,
na.rm=na.rm)} otherwise. Implemented methods for this generic are:
\itemize{
\item \code{meanWt.default(x, weights, na.rm=TRUE, ...)}
\item \code{meanWt.dataObj(x, vars, na.rm=TRUE, ...)}
}
\item \code{varWt}: calls \code{var(x, na.rm=na.rm)} if \code{weights} is missing.
Implemented methods for this generic are:
\itemize{
\item \code{varWt.default(x, weights, na.rm=TRUE, ...)}
\item \code{varWt.dataObj(x, vars, na.rm=TRUE, ...)}
}
\item \code{covWt} and \code{covWt}: always remove missing values pairwise and call
\code{cov} and \code{cor}, respectively, if \code{weights} is missing.
Implemented methods for these generics are:
\itemize{
\item \code{covWt.default(x, y, weights, ...)}
\item \code{covWt.matrix(x, weights, ...)}
\item \code{covWt.data.frame(x, weights, ...) }
\item \code{covWt.dataObj(x, vars, ...)}
\item \code{corWt.default(x, y, weights, ...)}
\item \code{corWt.matrix(x, weights, ...)}
\item \code{corWt.data.frame(x, weights, ...)}
\item \code{corWt.dataObj(x, vars, ...)}
}
}
The additional parameters are now described:
\itemize{
\item y: a numeric vector.  If missing, this defaults to \code{x}.
\item vars: a character vector of variable names that should be used for the
calculation.
\item na.rm: a logical indicating whether any \code{NA} or \code{NaN} values
should be removed from \code{x} before computation.  Note that the default
is \code{TRUE}.
\item weights: an optional numeric vector containing sample weights.
}
}
\note{
\code{meanWt}, \code{varWt}, \code{covWt} and \code{corWt} all make use of
slot \code{weights} of the input object if the \code{dataObj}-method is
used.
}
\examples{
data(eusilcS)
meanWt(eusilcS$netIncome, weights=eusilcS$rb050)
sqrt(varWt(eusilcS$netIncome, weights=eusilcS$rb050))

# dataObj-methods
inp <- specifyInput(data=eusilcS, hhid="db030", hhsize="hsize", strata="db040", weight="db090")
meanWt(inp, vars="netIncome")
sqrt(varWt(inp, vars="netIncome"))
corWt(inp, vars=c("age", "netIncome"))
covWt(inp, vars=c("age", "netIncome"))
}
\author{
Stefan Kraft and Andreas Alfons
}
\seealso{
\code{\link{mean}}, \code{\link[stats]{weighted.mean}},
\code{\link[stats:cor]{var}}, \code{\link[stats:cor]{cov}},
\code{\link[stats:cor]{cor}}
}
\keyword{array}
\keyword{multivariate}
\keyword{univar}

