\name{simComponents}
\alias{simComponents}
\title{
  Simulate components of continuous variables of population data
}
\description{
  Simulate components of continuous variables of population data by resampling fractions from survey data. The continuous variable to be split and any categorical conditioning variables need to be simulated beforehand.
}
\usage{
simComponents(simPopObj, total="netIncome",
  components=c("py010n", "py050n", "py090n", "py100n",
    "py110n","py120n", "py130n", "py140n"),
  conditional=c(getCatName(total), "pl030"),
  replaceEmpty=c("sequential", "min"), seed)
}
\arguments{
  \item{simPopObj}{a \code{\linkS4class{simPopObj}}-object.}
  \item{total}{a character string specifying the continuous variable of dataP that should be split into components. Currently, only one variable can be split at a time.}
  \item{components}{a character vector specifying the components in \code{dataS} that should be simulated for the population data.}
  \item{conditional}{an optional character vector specifying categorical conditioning variables for resampling. The fractions occurring in \code{dataS} are then drawn from the respective subsets defined by these variables.}
  \item{replaceEmpty}{a character string; if \code{conditional} specifies at least two conditioning variables, this determines how replacement cells for empty subsets in the sample are obtained. If \code{"sequential"}, the conditioning variables are browsed sequentially such that replacement cells have the same value in one conditioning variable and minimum Manhattan distance in the other conditioning variables. If no such cells exist, replacement cells with minimum overall Manhattan distance are selected. The latter is always done if this is \code{"min"} or only one conditioning variable is used.}
  \item{seed}{optional; an integer value to be used as the seed of the random number generator, or an integer vector containing the state of the random number generator to be restored.}
}
\value{
  An object of class \code{\linkS4class{simPopObj}} containing survey data as well as the simulated population data including the components of the continuous variable specified by \code{total} and \code{components}.
}
\author{Stefan Kraft and Andreas Alfons and Bernhard Meindl}
\note{
  The basic household structure, any categorical conditioning variables and the continuous variable to be split need to be simulated beforehand with the functions \code{\link{simStructure}}, \code{\link{simCategorical}} and \code{\link{simContinuous}}.
}
\seealso{
  \code{\link{simStructure}}, \code{\link{simCategorical}},
  \code{\link{simContinuous}}, \code{\link{simEUSILC}}
}
\examples{
\dontrun{
data(eusilcS)
inp <- specifyInput(data=eusilcS, hhid="db030", hhsize="hsize",
  strata="db040", weight="db090")
simPopObj <- simStructure(data=inp, method="direct",
  basicHHvars=c("age", "rb090", "hsize", "pl030", "pb220a"))
simPopObj <- simContinuous(simPopObj, additional = "netIncome",
  method="multinom", upper=200000, equidist=FALSE)

# categorize net income for use as conditioning variable
sIncome <- manageSimPopObj(simPopObj, var="netIncome", sample=TRUE, set=FALSE)
sWeight <- manageSimPopObj(simPopObj, var="rb050", sample=TRUE, set=FALSE)
pIncome <- manageSimPopObj(simPopObj, var="netIncome", sample=FALSE, set=FALSE)

breaks <- getBreaks(x=sIncome, w=sWeight, upper=Inf, equidist=FALSE)
simPopObj <- manageSimPopObj(simPopObj, var="netIncomeCat", sample=TRUE,
  set=TRUE, values=getCat(x=sIncome, breaks))
simPopObj <- manageSimPopObj(simPopObj, var="netIncomeCat", sample=FALSE,
  set=TRUE, values=getCat(x=pIncome, breaks))

# simulate net income components
simPopObj <- simComponents(simPopObj=simPopObj, total="netIncome",
  components=c("py010n","py050n","py090n","py100n","py110n","py120n","py130n","py140n"),
  conditional = c("netIncomeCat", "pl030"), replaceEmpty = "sequential", seed=1 )

class(simPopObj)
str(simPopObj)
}
}
\keyword{datagen}
