% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readvcf.R
\name{readVCF}
\alias{readVCF}
\title{Read a vcf file, with options to filter out low or high frequency markers.}
\usage{
readVCF(filename = "data.vcf", thin = NA, maxNumberOfVariants = 400,
  min_maf = 0.02, max_maf = NA, region_start = NA, region_end = NA)
}
\arguments{
\item{filename}{Input VCF file}

\item{thin}{How much to thin markers}

\item{maxNumberOfVariants}{Maximum number of variants to keep from region}

\item{min_maf}{Minimum allele frequency of markers to keep. If NA skip min_maf filtering.}

\item{max_maf}{Maximum allele frequency of markers to keep. If NA skip max_maf filtering.}

\item{region_start}{Extract a region from a vcf files with this starting basepair position}

\item{region_end}{Extract a region from a vcf files with this ending basepair position}
}
\value{
VCF object to be used by startSimulation function.
}
\description{
Read a vcf file, with options to filter out low or high frequency markers.
}
\examples{

examples_dir = system.file("examples", package = "sim1000G")
vcf_file = file.path(examples_dir,
  "region-chr4-93-TMEM156.vcf.gz")

vcf = readVCF( vcf_file, maxNumberOfVariants = 500 ,
               min_maf = 0.02 ,max_maf = NA)

str(as.list(vcf))
}
