% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{newNuclearFamily}
\alias{newNuclearFamily}
\title{Simulates genotypes for 1 family with 1 offspring}
\usage{
newNuclearFamily(family_id)
}
\arguments{
\item{family_id}{What will be the family_id (for example: 100)}
}
\value{
family structure object
}
\description{
Simulates genotypes for 1 family with 1 offspring
}
\examples{

library("sim1000G")

examples_dir = system.file("examples", package = "sim1000G")
vcf_file = sprintf("\%s/region.vcf.gz", examples_dir)
vcf = readVCF( vcf_file, maxNumberOfVariants = 100 , min_maf = 0.12 ,max_maf = NA)

genetic_map_of_region = system.file("examples","chr4-geneticmap.txt", package = "sim1000G")
readGeneticMapFromFile(genetic_map_of_region)

startSimulation(vcf, totalNumberOfIndividuals = 1200)
fam1 = newNuclearFamily(1)
fam2 = newNuclearFamily(2)

# See also the documentation on our github page

}

