% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROC.R
\name{find_AUC_q}
\alias{find_AUC_q}
\title{Find area matching polynomial curve.}
\usage{
find_AUC_q(
  modelPredictions,
  yValues,
  ...,
  na.rm = FALSE,
  yTarget = TRUE,
  n_points = 101
)
}
\arguments{
\item{modelPredictions}{numeric predictions (not empty), ordered (either increasing or decreasing)}

\item{yValues}{truth values (not empty, same length as model predictions)}

\item{...}{force later arguments to bind by name.}

\item{na.rm}{logical, if TRUE remove NA values.}

\item{yTarget}{value considered to be positive.}

\item{n_points}{number of points to use in estimates.}
}
\value{
q that such that curve 1 - (1 -  (1-ideal_roc$Specificity)^q)^(1/q) matches area
}
\description{
Based on \url{https://win-vector.com/2020/09/13/why-working-with-auc-is-more-powerful-than-one-might-think/}
}
\examples{

d <- data.frame(pred = 1:4, truth = c(TRUE,FALSE,TRUE,TRUE))
q <- find_AUC_q(d$pred, d$truth)
roc <- build_ROC_curve(d$pred, d$truth)
ideal_roc <- data.frame(Specificity = seq(0, 1, length.out = 101))
ideal_roc$Sensitivity <- sensitivity_from_specificity_q(ideal_roc$Specificity, q)
# library(ggplot2)
# ggplot(mapping = aes(x = 1 - Specificity, y = Sensitivity)) +
#   geom_line(data = roc, color = "DarkBlue") +
#   geom_line(data  = ideal_roc, color = "Orange") +
#   theme(aspect.ratio=1) +
#   ggtitle("example actual and ideal curve")

}
