% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{graph_from_edgelist_signed}
\alias{graph_from_edgelist_signed}
\title{Create a signed graph from an edgelist matrix}
\usage{
graph_from_edgelist_signed(el, signs, directed = FALSE)
}
\arguments{
\item{el}{The edgelist, a two column matrix, character or numeric.}

\item{signs}{vector indicating the sign of edges. Entries must be 1 or -1.}

\item{directed}{whether to create a directed graph.}
}
\value{
a signed network as igraph object
}
\description{
Create a signed graph from an edgelist matrix
}
\examples{
el <- matrix(c("foo", "bar", "bar", "foobar"), ncol = 2, byrow = TRUE)
signs <- c(-1, 1)
graph_from_edgelist_signed(el, signs)
}
