% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{duration_viterbi}
\alias{duration_viterbi}
\title{Compute most probable path with extended Viterbi algorithm.}
\usage{
duration_viterbi(aa_sample, pipar, tpmpar, od, params)
}
\arguments{
\item{aa_sample}{\code{character} vector representing single aminoacid sequence.}

\item{pipar}{probabilities of initial state in Markov Model.}

\item{tpmpar}{matrix of transition probabilities between states.}

\item{od}{matrix of response probabilities. Eg. od[1,2] is a probability of signal 2 in state 1.}

\item{params}{matrix of probability distribution for duration. Eg. params[10,2] is probability of duration of time 10 in state 2.}
}
\value{
A list of length four:
\itemize{
 \item{path}{ a vector of most probable path}
 \item{viterbi}{ values of probability in all intermediate points,}
 \item{psi}{ matrix that gives for every signal and state the previous state in viterbi path,}
 \item{duration}{ matrix that gives for every signal and state gives the duration in that state on viterbi path.}
 }
}
\description{
Viterbi algorithm for Hidden Markov Model with duration
}
\note{
All computations are on logarithms of probabilities.
}

