% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_group_mapping.R
\name{show_group_mapping}
\alias{show_group_mapping}
\title{Map Groups using Sankey}
\usage{
show_group_mapping(
  data,
  col_to_flow,
  cols_to_map,
  include_sig = FALSE,
  fill_na = FALSE,
  title = NULL,
  xlab = NULL,
  ylab = NULL,
  custom_theme = cowplot::theme_minimal_hgrid()
)
}
\arguments{
\item{data}{a \code{data.frame} containing signature group and other categorical groups.}

\item{col_to_flow}{length-1 character showing the column to flow, typically a signature group.}

\item{cols_to_map}{character vector showing colnames of other groups.}

\item{include_sig}{default if \code{FALSE}, if \code{TRUE}, showing signature group.}

\item{fill_na}{length-1 string to fill NA, default is \code{FALSE}.}

\item{title}{the title.}

\item{xlab}{label for x axis.}

\item{ylab}{label for y axis.}

\item{custom_theme}{theme for plotting, default is \code{cowplot::theme_minimal_hgrid()}.}
}
\value{
a \code{ggplot} object
}
\description{
This feature is designed for signature analysis. However, users can also use
it in other similar situations.
}
\examples{
data <- dplyr::tibble(
  Group1 = rep(LETTERS[1:5], each = 10),
  Group2 = rep(LETTERS[6:15], each = 5),
  zzzz = c(rep("xx", 20), rep("yy", 20), rep(NA, 10))
)
p1 <- show_group_mapping(data, col_to_flow = "Group1", cols_to_map = colnames(data)[-1])
p1

p2 <- show_group_mapping(data,
  col_to_flow = "Group1", cols_to_map = colnames(data)[-1],
  include_sig = TRUE
)
p2
}
