% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_vcf.R
\name{read_xena_variants}
\alias{read_xena_variants}
\title{Read UCSC Xena Variant Format Data as MAF Object}
\usage{
read_xena_variants(path)
}
\arguments{
\item{path}{a path to variant file.}
}
\value{
a \code{MAF} object.
}
\description{
Read UCSC Xena Variant Format Data as MAF Object
}
\examples{
\donttest{
if (requireNamespace("UCSCXenaTools")) {
  library(UCSCXenaTools)
  options(use_hiplot = TRUE)
  example_file <- XenaGenerate(subset = XenaDatasets == "mc3/ACC_mc3.txt") \%>\%
    XenaQuery() \%>\%
    XenaDownload()
  x <- read_xena_variants(example_file$destfiles)
  x@data
  y <- sig_tally(x)
  y
}
}
}
