% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_catalogue.R
\name{show_catalogue}
\alias{show_catalogue}
\title{Show Alteration Catalogue Profile}
\usage{
show_catalogue(
  catalogue,
  mode = c("SBS", "copynumber"),
  method = "Wang",
  normalize = c("raw", "row", "feature"),
  style = c("default", "cosmic"),
  samples = NULL,
  samples_name = NULL,
  x_lab = "Components",
  y_lab = "Counts",
  ...
)
}
\arguments{
\item{catalogue}{result from \link{sig_tally} or a
matrix with row representing components (motifs) and
column representing samples}

\item{mode}{signature type for plotting, now supports 'copynumber' or 'SBS'.}

\item{method}{method for copy number feature classfication in \link{sig_tally},
can be one of "Macintyre" ("M") and "Wang" ("W").}

\item{normalize}{normalize method.}

\item{style}{plot style, one of 'default' and 'cosmic'.}

\item{samples}{default is \code{NULL}, show sum of all samples in one row.
If not \code{NULL}, show specified samples.}

\item{samples_name}{set the sample names shown in plot.}

\item{x_lab}{x axis lab.}

\item{y_lab}{y axis lab.}

\item{...}{other arguments passing to \link{show_sig_profile}.}
}
\value{
a \code{ggplot} object
}
\description{
Show Alteration Catalogue Profile
}
\examples{
load(system.file("extdata", "toy_copynumber_tally_M.RData",
  package = "sigminer", mustWork = TRUE
))
p <- show_catalogue(cn_tally_M,
  mode = "copynumber", method = "M",
  style = "cosmic", paint_axis_text = FALSE
)
p
}
