% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{sg_drop_nodes}
\alias{sg_drop_nodes}
\alias{sg_drop_edges}
\title{Drop}
\usage{
sg_drop_nodes(sg, data, ids, delay, cumsum = TRUE)

sg_drop_edges(sg, data, ids, delay, cumsum = TRUE, refresh = FALSE)
}
\arguments{
\item{sg}{An object of class \code{sigmajs}as intatiated by \code{\link{sigmajs}}.}

\item{data}{Data.frame (or list) of nodes or edges.}

\item{ids}{Ids of elements to drop.}

\item{delay}{Column name containing delay in milliseconds.}

\item{cumsum}{Whether to compute the cumulative sum of the delay.}

\item{refresh}{Whether to refresh the graph after node is dropped, required to take effect, if you are running force the algorithm is killed and restarted at every iteration.}
}
\description{
Drop nodes or edges.
}
\details{
The delay helps for build dynamic visualisations where nodes and edges do not disappear all at the same time.
How the delay works depends on the \code{cumsum} parameter. if \code{TRUE} the function computes the cumulative sum
of the delay to effectively drop each row one after the other: delay is thus applied at each row (number of seconds to wait
before the row is dropped *since the previous row*). If \code{FALSE} this is the number of milliseconds to wait before the node or
edge is dropped to the visualisation; \code{delay} is used as passed to the function.
}
\examples{
nodes <- sg_make_nodes(75)

# nodes to drop
nodes2 <- nodes[sample(nrow(nodes), 50), ]
nodes2$delay <- runif(nrow(nodes2), 1000, 3000)

sigmajs() \%>\% 
  sg_nodes(nodes, id, size, color) \%>\% 
  sg_drop_nodes(nodes2, id, delay, cumsum = FALSE)

}
