% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{sg_nodes}
\alias{sg_nodes}
\alias{sg_edges}
\alias{sg_edges2}
\alias{sg_nodes2}
\title{Add nodes and edges}
\usage{
sg_nodes(sg, data, ...)

sg_edges(sg, data, ...)

sg_edges2(sg, data)

sg_nodes2(sg, data)
}
\arguments{
\item{sg}{An object of class \code{sigmajs}as intatiated by \code{\link{sigmajs}}.}

\item{data}{Data.frame (or list) of nodes or edges.}

\item{...}{any column.}
}
\description{
Add nodes and edges to a \code{sigmajs} graph.
}
\details{
Each node must include a unique id, ideally the user passes \code{x} and \code{y}, if they are not passed then they are randomly generated.
Each edge also must include a unique \code{id} as well as two columns named \code{source} and \code{target}.
}
\note{
\code{node} also takes a \link[crosstalk]{SharedData}.
}
\section{Functions}{

\itemize{
	\item{Functions ending in \code{2} take a list like the original sigma.js JSON.}
	\item{Other functions take the arguments described above.}
}
}

\examples{
nodes <- sg_make_nodes()
edges <- sg_make_edges(nodes)

edges$type <- "arrow" # directed

sigmajs() \%>\%
  sg_nodes(nodes, id, label, size, color) \%>\%
  sg_edges(edges, id, source, target, type) 

}
