% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{sg_add_nodes}
\alias{sg_add_nodes}
\alias{sg_add_edges}
\title{Add nodes and edges}
\usage{
sg_add_nodes(sg, data, delay, ..., cumsum = TRUE)

sg_add_edges(sg, data, delay, ..., cumsum = TRUE, refresh = FALSE)
}
\arguments{
\item{sg}{An object of class \code{sigmajs}as intatiated by \code{\link{sigmajs}}.}

\item{data}{Data.frame (or list) of nodes or edges.}

\item{delay}{Column name containing delay in milliseconds.}

\item{...}{any column.}

\item{cumsum}{Whether to compute the cumulative sum of the delay.}

\item{refresh}{Whether to refresh the graph after node is dropped, required to take effect, if you are running force the algorithm is killed and restarted at every iteration.}
}
\description{
Add nodes or edges.
}
\details{
The delay helps for build dynamic visualisations where nodes and edges do not appear all at the same time.
How the delay works depends on the \code{cumsum} parameter. if \code{TRUE} the function computes the cumulative sum
of the delay to effectively add each row one after the other: delay is thus applied at each row (number of seconds to wait
before the row is added *since the previous row*). If \code{FALSE} this is the number of milliseconds to wait before the node or
edge is added to the visualisation; \code{delay} is used as passed to the function.
}
\examples{
# initial nodes
nodes <- sg_make_nodes()

# additional nodes
nodes2 <- sg_make_nodes()
nodes2$id <- as.character(seq(11, 20))

# add delay
nodes2$delay <- runif(nrow(nodes2), 500, 1000)

sigmajs() \%>\%
  sg_nodes(nodes, id, label, size, color) \%>\%
  sg_add_nodes(nodes2, delay, id, label, size, color)
  
edges <- sg_make_edges(nodes, 25)
edges$delay <- runif(nrow(edges), 100, 2000)

sigmajs() \%>\%
  sg_force_start() \%>\%
  sg_nodes(nodes, id, label, size, color) \%>\% 
  sg_add_edges(edges, delay, id, source, target, cumsum = FALSE) \%>\%
  sg_force_stop(2300) # stop after all edges added

}
