% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numericalReCalculation.R
\name{numericalReCalculation}
\alias{numericalReCalculation}
\title{Calls fitting algorithm with different initial parameters.}
\usage{
numericalReCalculation(parameterVector, stepSize = 1e-05)
}
\arguments{
\item{parameterVector}{output of fitFunction or data frame that gives the variables related with double sigmoidal fit.}

\item{stepSize}{step size used by the fitting algorithm.}
}
\value{
Returns the parameters related with fitted curve to input data.
}
\description{
Calls the fitting algorithms and fits the data  with random initial parameters.
}
\examples{
time=seq(3,24,0.1)

#simulate intensity data and add noise
noise_parameter=0.2
intensity_noise=runif(n = length(time),min = 0,max = 1)*noise_parameter
initialParameters=data.frame(dataScalingParameters.timeRatio=24,
                                 finalAsymptoteIntensity_Estimate=.3,
                                 maximum_Estimate=4,
                                 slope1_Estimate=1,
                                 midPoint1_Estimate=7,
                                 slope2_Estimate=1,
                                 midPointDistance_Estimate=8,
                                 model="doublesigmoidal")

initialParameters = numericalReCalculation(initialParameters, stepSize=0.00001)

intensity=
 doublesigmoidalFitFormula(
         time,
         finalAsymptoteIntensity=initialParameters$finalAsymptoteIntensity_Estimate,
         maximum=initialParameters$maximum_Estimate,
         slope1=initialParameters$slope1_Estimate,
         midPoint1=initialParameters$midPoint1_Estimate,
         slope2=initialParameters$slope2_Estimate,
         midPointDistance=initialParameters$midPointDistance_Estimate)


intensity=intensity+intensity_noise

dataInput=data.frame(intensity=intensity,time=time)
normalizeInput = normalizeData(dataInput)
parameterVector=fitFunction(dataInput=normalizeInput,
                           dataInputName="batch_01_21_2016_samp007623",
                           model="doublesigmoidal",
                           n_runs_min=20,
                           n_runs_max=500,
                           showDetails=FALSE)


dataOutput2 = numericalReCalculation(parameterVector, stepSize=0.00001)

}

